package zio.aws.evidently.model
import scala.jdk.CollectionConverters.*
sealed trait VariationValueType {
  def unwrap: software.amazon.awssdk.services.evidently.model.VariationValueType
}
object VariationValueType {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.VariationValueType
  ): zio.aws.evidently.model.VariationValueType = value match {
    case software.amazon.awssdk.services.evidently.model.VariationValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.VariationValueType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.evidently.model.VariationValueType.LONG =>
      val r = LONG
      r
    case software.amazon.awssdk.services.evidently.model.VariationValueType.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.evidently.model.VariationValueType.BOOLEAN =>
      val r = BOOLEAN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.VariationValueType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.VariationValueType =
      software.amazon.awssdk.services.evidently.model.VariationValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object STRING extends zio.aws.evidently.model.VariationValueType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.VariationValueType =
      software.amazon.awssdk.services.evidently.model.VariationValueType.STRING
  }
  case object LONG extends zio.aws.evidently.model.VariationValueType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.VariationValueType =
      software.amazon.awssdk.services.evidently.model.VariationValueType.LONG
  }
  case object DOUBLE extends zio.aws.evidently.model.VariationValueType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.VariationValueType =
      software.amazon.awssdk.services.evidently.model.VariationValueType.DOUBLE
  }
  case object BOOLEAN extends zio.aws.evidently.model.VariationValueType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.VariationValueType =
      software.amazon.awssdk.services.evidently.model.VariationValueType.BOOLEAN
  }
}
