package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.VariationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VariationConfig(
    name: VariationName,
    value: zio.aws.evidently.model.VariableValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.VariationConfig = {
    import VariationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.VariationConfig
      .builder()
      .name(VariationName.unwrap(name): java.lang.String)
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.VariationConfig.ReadOnly =
    zio.aws.evidently.model.VariationConfig.wrap(buildAwsValue())
}
object VariationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.VariationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.VariationConfig =
      zio.aws.evidently.model.VariationConfig(name, value.asEditable)
    def name: VariationName
    def value: zio.aws.evidently.model.VariableValue.ReadOnly
    def getName: ZIO[Any, Nothing, VariationName] = ZIO.succeed(name)
    def getValue
        : ZIO[Any, Nothing, zio.aws.evidently.model.VariableValue.ReadOnly] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.VariationConfig
  ) extends zio.aws.evidently.model.VariationConfig.ReadOnly {
    override val name: VariationName =
      zio.aws.evidently.model.primitives.VariationName(impl.name())
    override val value: zio.aws.evidently.model.VariableValue.ReadOnly =
      zio.aws.evidently.model.VariableValue.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.VariationConfig
  ): zio.aws.evidently.model.VariationConfig.ReadOnly = new Wrapper(impl)
}
