package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  VariationName,
  ProjectRef,
  Description,
  EntityId,
  FeatureName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFeatureRequest(
    addOrUpdateVariations: Optional[
      Iterable[zio.aws.evidently.model.VariationConfig]
    ] = Optional.Absent,
    defaultVariation: Optional[VariationName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    entityOverrides: Optional[Map[EntityId, VariationName]] = Optional.Absent,
    evaluationStrategy: Optional[
      zio.aws.evidently.model.FeatureEvaluationStrategy
    ] = Optional.Absent,
    feature: FeatureName,
    project: ProjectRef,
    removeVariations: Optional[Iterable[VariationName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest = {
    import UpdateFeatureRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest
      .builder()
      .optionallyWith(
        addOrUpdateVariations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOrUpdateVariations)
      .optionallyWith(
        defaultVariation.map(value =>
          VariationName.unwrap(value): java.lang.String
        )
      )(_.defaultVariation)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        entityOverrides.map(value =>
          value
            .map({ case (key, value) =>
              (EntityId.unwrap(key): java.lang.String) -> (VariationName.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.entityOverrides)
      .optionallyWith(evaluationStrategy.map(value => value.unwrap))(
        _.evaluationStrategy
      )
      .feature(FeatureName.unwrap(feature): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        removeVariations.map(value =>
          value.map { item =>
            VariationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeVariations)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.UpdateFeatureRequest.ReadOnly =
    zio.aws.evidently.model.UpdateFeatureRequest.wrap(buildAwsValue())
}
object UpdateFeatureRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UpdateFeatureRequest =
      zio.aws.evidently.model.UpdateFeatureRequest(
        addOrUpdateVariations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultVariation.map(value => value),
        description.map(value => value),
        entityOverrides.map(value => value),
        evaluationStrategy.map(value => value),
        feature,
        project,
        removeVariations.map(value => value)
      )
    def addOrUpdateVariations
        : Optional[List[zio.aws.evidently.model.VariationConfig.ReadOnly]]
    def defaultVariation: Optional[VariationName]
    def description: Optional[Description]
    def entityOverrides: Optional[Map[EntityId, VariationName]]
    def evaluationStrategy
        : Optional[zio.aws.evidently.model.FeatureEvaluationStrategy]
    def feature: FeatureName
    def project: ProjectRef
    def removeVariations: Optional[List[VariationName]]
    def getAddOrUpdateVariations: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.VariationConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("addOrUpdateVariations", addOrUpdateVariations)
    def getDefaultVariation: ZIO[Any, AwsError, VariationName] =
      AwsError.unwrapOptionField("defaultVariation", defaultVariation)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEntityOverrides: ZIO[Any, AwsError, Map[EntityId, VariationName]] =
      AwsError.unwrapOptionField("entityOverrides", entityOverrides)
    def getEvaluationStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.FeatureEvaluationStrategy
    ] = AwsError.unwrapOptionField("evaluationStrategy", evaluationStrategy)
    def getFeature: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(feature)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getRemoveVariations: ZIO[Any, AwsError, List[VariationName]] =
      AwsError.unwrapOptionField("removeVariations", removeVariations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest
  ) extends zio.aws.evidently.model.UpdateFeatureRequest.ReadOnly {
    override val addOrUpdateVariations
        : Optional[List[zio.aws.evidently.model.VariationConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addOrUpdateVariations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.VariationConfig.wrap(item)
          }.toList
        )
    override val defaultVariation: Optional[VariationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultVariation())
        .map(value => zio.aws.evidently.model.primitives.VariationName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val entityOverrides: Optional[Map[EntityId, VariationName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityOverrides())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.evidently.model.primitives.EntityId(
                key
              ) -> zio.aws.evidently.model.primitives.VariationName(value)
            })
            .toMap
        )
    override val evaluationStrategy
        : Optional[zio.aws.evidently.model.FeatureEvaluationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationStrategy())
        .map(value =>
          zio.aws.evidently.model.FeatureEvaluationStrategy.wrap(value)
        )
    override val feature: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.feature())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val removeVariations: Optional[List[VariationName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeVariations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.primitives.VariationName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest
  ): zio.aws.evidently.model.UpdateFeatureRequest.ReadOnly = new Wrapper(impl)
}
