package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RefResource(
    arn: Optional[String] = Optional.Absent,
    endTime: Optional[String] = Optional.Absent,
    lastUpdatedOn: Optional[String] = Optional.Absent,
    name: String,
    startTime: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    `type`: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.RefResource = {
    import RefResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.RefResource
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(endTime.map(value => value: java.lang.String))(_.endTime)
      .optionallyWith(lastUpdatedOn.map(value => value: java.lang.String))(
        _.lastUpdatedOn
      )
      .name(name: java.lang.String)
      .optionallyWith(startTime.map(value => value: java.lang.String))(
        _.startTime
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.RefResource.ReadOnly =
    zio.aws.evidently.model.RefResource.wrap(buildAwsValue())
}
object RefResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.RefResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.RefResource =
      zio.aws.evidently.model.RefResource(
        arn.map(value => value),
        endTime.map(value => value),
        lastUpdatedOn.map(value => value),
        name,
        startTime.map(value => value),
        status.map(value => value),
        `type`
      )
    def arn: Optional[String]
    def endTime: Optional[String]
    def lastUpdatedOn: Optional[String]
    def name: String
    def startTime: Optional[String]
    def status: Optional[String]
    def `type`: String
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getEndTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getLastUpdatedOn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastUpdatedOn", lastUpdatedOn)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getStartTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.RefResource
  ) extends zio.aws.evidently.model.RefResource.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val endTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: String)
    override val lastUpdatedOn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedOn())
      .map(value => value: String)
    override val name: String = impl.name(): String
    override val startTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val `type`: String = impl.`type`(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.RefResource
  ): zio.aws.evidently.model.RefResource.ReadOnly = new Wrapper(impl)
}
