package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProjectDataDelivery(
    cloudWatchLogs: Optional[
      zio.aws.evidently.model.CloudWatchLogsDestination
    ] = Optional.Absent,
    s3Destination: Optional[zio.aws.evidently.model.S3Destination] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ProjectDataDelivery = {
    import ProjectDataDelivery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ProjectDataDelivery
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ProjectDataDelivery.ReadOnly =
    zio.aws.evidently.model.ProjectDataDelivery.wrap(buildAwsValue())
}
object ProjectDataDelivery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ProjectDataDelivery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ProjectDataDelivery =
      zio.aws.evidently.model.ProjectDataDelivery(
        cloudWatchLogs.map(value => value.asEditable),
        s3Destination.map(value => value.asEditable)
      )
    def cloudWatchLogs
        : Optional[zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly]
    def s3Destination: Optional[zio.aws.evidently.model.S3Destination.ReadOnly]
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getS3Destination
        : ZIO[Any, AwsError, zio.aws.evidently.model.S3Destination.ReadOnly] =
      AwsError.unwrapOptionField("s3Destination", s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ProjectDataDelivery
  ) extends zio.aws.evidently.model.ProjectDataDelivery.ReadOnly {
    override val cloudWatchLogs
        : Optional[zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogs())
        .map(value =>
          zio.aws.evidently.model.CloudWatchLogsDestination.wrap(value)
        )
    override val s3Destination
        : Optional[zio.aws.evidently.model.S3Destination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Destination())
        .map(value => zio.aws.evidently.model.S3Destination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ProjectDataDelivery
  ): zio.aws.evidently.model.ProjectDataDelivery.ReadOnly = new Wrapper(impl)
}
