package zio.aws.evidently.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.{
  ProjectName,
  Timestamp,
  TagValue,
  ProjectArn,
  Description,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class Project(
    activeExperimentCount: Optional[Long] = Optional.Absent,
    activeLaunchCount: Optional[Long] = Optional.Absent,
    appConfigResource: Optional[
      zio.aws.evidently.model.ProjectAppConfigResource
    ] = Optional.Absent,
    arn: ProjectArn,
    createdTime: Timestamp,
    dataDelivery: Optional[zio.aws.evidently.model.ProjectDataDelivery] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    experimentCount: Optional[Long] = Optional.Absent,
    featureCount: Optional[Long] = Optional.Absent,
    lastUpdatedTime: Timestamp,
    launchCount: Optional[Long] = Optional.Absent,
    name: ProjectName,
    status: zio.aws.evidently.model.ProjectStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.Project = {
    import Project.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.Project
      .builder()
      .optionallyWith(
        activeExperimentCount.map(value => value: java.lang.Long)
      )(_.activeExperimentCount)
      .optionallyWith(activeLaunchCount.map(value => value: java.lang.Long))(
        _.activeLaunchCount
      )
      .optionallyWith(appConfigResource.map(value => value.buildAwsValue()))(
        _.appConfigResource
      )
      .arn(ProjectArn.unwrap(arn): java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .optionallyWith(dataDelivery.map(value => value.buildAwsValue()))(
        _.dataDelivery
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(experimentCount.map(value => value: java.lang.Long))(
        _.experimentCount
      )
      .optionallyWith(featureCount.map(value => value: java.lang.Long))(
        _.featureCount
      )
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .optionallyWith(launchCount.map(value => value: java.lang.Long))(
        _.launchCount
      )
      .name(ProjectName.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.Project.ReadOnly =
    zio.aws.evidently.model.Project.wrap(buildAwsValue())
}
object Project {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.evidently.model.Project] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.Project =
      zio.aws.evidently.model.Project(
        activeExperimentCount.map(value => value),
        activeLaunchCount.map(value => value),
        appConfigResource.map(value => value.asEditable),
        arn,
        createdTime,
        dataDelivery.map(value => value.asEditable),
        description.map(value => value),
        experimentCount.map(value => value),
        featureCount.map(value => value),
        lastUpdatedTime,
        launchCount.map(value => value),
        name,
        status,
        tags.map(value => value)
      )
    def activeExperimentCount: Optional[Long]
    def activeLaunchCount: Optional[Long]
    def appConfigResource
        : Optional[zio.aws.evidently.model.ProjectAppConfigResource.ReadOnly]
    def arn: ProjectArn
    def createdTime: Timestamp
    def dataDelivery
        : Optional[zio.aws.evidently.model.ProjectDataDelivery.ReadOnly]
    def description: Optional[Description]
    def experimentCount: Optional[Long]
    def featureCount: Optional[Long]
    def lastUpdatedTime: Timestamp
    def launchCount: Optional[Long]
    def name: ProjectName
    def status: zio.aws.evidently.model.ProjectStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def getActiveExperimentCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("activeExperimentCount", activeExperimentCount)
    def getActiveLaunchCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("activeLaunchCount", activeLaunchCount)
    def getAppConfigResource: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ProjectAppConfigResource.ReadOnly
    ] = AwsError.unwrapOptionField("appConfigResource", appConfigResource)
    def getArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(arn)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getDataDelivery: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ProjectDataDelivery.ReadOnly
    ] = AwsError.unwrapOptionField("dataDelivery", dataDelivery)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getExperimentCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("experimentCount", experimentCount)
    def getFeatureCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("featureCount", featureCount)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
    def getLaunchCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("launchCount", launchCount)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getStatus: ZIO[Any, Nothing, zio.aws.evidently.model.ProjectStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.Project
  ) extends zio.aws.evidently.model.Project.ReadOnly {
    override val activeExperimentCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.activeExperimentCount())
      .map(value => value: Long)
    override val activeLaunchCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.activeLaunchCount())
      .map(value => value: Long)
    override val appConfigResource
        : Optional[zio.aws.evidently.model.ProjectAppConfigResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appConfigResource())
        .map(value =>
          zio.aws.evidently.model.ProjectAppConfigResource.wrap(value)
        )
    override val arn: ProjectArn =
      zio.aws.evidently.model.primitives.ProjectArn(impl.arn())
    override val createdTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.createdTime())
    override val dataDelivery
        : Optional[zio.aws.evidently.model.ProjectDataDelivery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataDelivery())
        .map(value => zio.aws.evidently.model.ProjectDataDelivery.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val experimentCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.experimentCount())
      .map(value => value: Long)
    override val featureCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.featureCount())
      .map(value => value: Long)
    override val lastUpdatedTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.lastUpdatedTime())
    override val launchCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.launchCount())
      .map(value => value: Long)
    override val name: ProjectName =
      zio.aws.evidently.model.primitives.ProjectName(impl.name())
    override val status: zio.aws.evidently.model.ProjectStatus =
      zio.aws.evidently.model.ProjectStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.Project
  ): zio.aws.evidently.model.Project.ReadOnly = new Wrapper(impl)
}
