package zio.aws.evidently.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.{
  SplitWeight,
  ExperimentArn,
  Timestamp,
  TagValue,
  ProjectArn,
  RandomizationSalt,
  Description,
  ExperimentName,
  TagKey,
  SegmentArn
}
import scala.jdk.CollectionConverters.*
final case class Experiment(
    arn: ExperimentArn,
    createdTime: Timestamp,
    description: Optional[Description] = Optional.Absent,
    execution: Optional[zio.aws.evidently.model.ExperimentExecution] =
      Optional.Absent,
    lastUpdatedTime: Timestamp,
    metricGoals: Optional[Iterable[zio.aws.evidently.model.MetricGoal]] =
      Optional.Absent,
    name: ExperimentName,
    onlineAbDefinition: Optional[zio.aws.evidently.model.OnlineAbDefinition] =
      Optional.Absent,
    project: Optional[ProjectArn] = Optional.Absent,
    randomizationSalt: Optional[RandomizationSalt] = Optional.Absent,
    samplingRate: Optional[SplitWeight] = Optional.Absent,
    schedule: Optional[zio.aws.evidently.model.ExperimentSchedule] =
      Optional.Absent,
    segment: Optional[SegmentArn] = Optional.Absent,
    status: zio.aws.evidently.model.ExperimentStatus,
    statusReason: Optional[Description] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    treatments: Optional[Iterable[zio.aws.evidently.model.Treatment]] =
      Optional.Absent,
    `type`: zio.aws.evidently.model.ExperimentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.Experiment = {
    import Experiment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.Experiment
      .builder()
      .arn(ExperimentArn.unwrap(arn): java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(execution.map(value => value.buildAwsValue()))(
        _.execution
      )
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .optionallyWith(
        metricGoals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricGoals)
      .name(ExperimentName.unwrap(name): java.lang.String)
      .optionallyWith(onlineAbDefinition.map(value => value.buildAwsValue()))(
        _.onlineAbDefinition
      )
      .optionallyWith(
        project.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.project)
      .optionallyWith(
        randomizationSalt.map(value =>
          RandomizationSalt.unwrap(value): java.lang.String
        )
      )(_.randomizationSalt)
      .optionallyWith(
        samplingRate.map(value => SplitWeight.unwrap(value): java.lang.Long)
      )(_.samplingRate)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        segment.map(value => SegmentArn.unwrap(value): java.lang.String)
      )(_.segment)
      .status(status.unwrap)
      .optionallyWith(
        statusReason.map(value => Description.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        treatments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.treatments)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.Experiment.ReadOnly =
    zio.aws.evidently.model.Experiment.wrap(buildAwsValue())
}
object Experiment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.Experiment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.Experiment =
      zio.aws.evidently.model.Experiment(
        arn,
        createdTime,
        description.map(value => value),
        execution.map(value => value.asEditable),
        lastUpdatedTime,
        metricGoals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name,
        onlineAbDefinition.map(value => value.asEditable),
        project.map(value => value),
        randomizationSalt.map(value => value),
        samplingRate.map(value => value),
        schedule.map(value => value.asEditable),
        segment.map(value => value),
        status,
        statusReason.map(value => value),
        tags.map(value => value),
        treatments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`
      )
    def arn: ExperimentArn
    def createdTime: Timestamp
    def description: Optional[Description]
    def execution
        : Optional[zio.aws.evidently.model.ExperimentExecution.ReadOnly]
    def lastUpdatedTime: Timestamp
    def metricGoals: Optional[List[zio.aws.evidently.model.MetricGoal.ReadOnly]]
    def name: ExperimentName
    def onlineAbDefinition
        : Optional[zio.aws.evidently.model.OnlineAbDefinition.ReadOnly]
    def project: Optional[ProjectArn]
    def randomizationSalt: Optional[RandomizationSalt]
    def samplingRate: Optional[SplitWeight]
    def schedule: Optional[zio.aws.evidently.model.ExperimentSchedule.ReadOnly]
    def segment: Optional[SegmentArn]
    def status: zio.aws.evidently.model.ExperimentStatus
    def statusReason: Optional[Description]
    def tags: Optional[Map[TagKey, TagValue]]
    def treatments: Optional[List[zio.aws.evidently.model.Treatment.ReadOnly]]
    def `type`: zio.aws.evidently.model.ExperimentType
    def getArn: ZIO[Any, Nothing, ExperimentArn] = ZIO.succeed(arn)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getExecution: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ExperimentExecution.ReadOnly
    ] = AwsError.unwrapOptionField("execution", execution)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
    def getMetricGoals: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.MetricGoal.ReadOnly
    ]] = AwsError.unwrapOptionField("metricGoals", metricGoals)
    def getName: ZIO[Any, Nothing, ExperimentName] = ZIO.succeed(name)
    def getOnlineAbDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.OnlineAbDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("onlineAbDefinition", onlineAbDefinition)
    def getProject: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("project", project)
    def getRandomizationSalt: ZIO[Any, AwsError, RandomizationSalt] =
      AwsError.unwrapOptionField("randomizationSalt", randomizationSalt)
    def getSamplingRate: ZIO[Any, AwsError, SplitWeight] =
      AwsError.unwrapOptionField("samplingRate", samplingRate)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ExperimentSchedule.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getSegment: ZIO[Any, AwsError, SegmentArn] =
      AwsError.unwrapOptionField("segment", segment)
    def getStatus: ZIO[Any, Nothing, zio.aws.evidently.model.ExperimentStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTreatments
        : ZIO[Any, AwsError, List[zio.aws.evidently.model.Treatment.ReadOnly]] =
      AwsError.unwrapOptionField("treatments", treatments)
    def getType: ZIO[Any, Nothing, zio.aws.evidently.model.ExperimentType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.Experiment
  ) extends zio.aws.evidently.model.Experiment.ReadOnly {
    override val arn: ExperimentArn =
      zio.aws.evidently.model.primitives.ExperimentArn(impl.arn())
    override val createdTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.createdTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val execution
        : Optional[zio.aws.evidently.model.ExperimentExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.execution())
        .map(value => zio.aws.evidently.model.ExperimentExecution.wrap(value))
    override val lastUpdatedTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.lastUpdatedTime())
    override val metricGoals
        : Optional[List[zio.aws.evidently.model.MetricGoal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricGoals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.MetricGoal.wrap(item)
          }.toList
        )
    override val name: ExperimentName =
      zio.aws.evidently.model.primitives.ExperimentName(impl.name())
    override val onlineAbDefinition
        : Optional[zio.aws.evidently.model.OnlineAbDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onlineAbDefinition())
        .map(value => zio.aws.evidently.model.OnlineAbDefinition.wrap(value))
    override val project: Optional[ProjectArn] = zio.aws.core.internal
      .optionalFromNullable(impl.project())
      .map(value => zio.aws.evidently.model.primitives.ProjectArn(value))
    override val randomizationSalt: Optional[RandomizationSalt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.randomizationSalt())
        .map(value =>
          zio.aws.evidently.model.primitives.RandomizationSalt(value)
        )
    override val samplingRate: Optional[SplitWeight] = zio.aws.core.internal
      .optionalFromNullable(impl.samplingRate())
      .map(value => zio.aws.evidently.model.primitives.SplitWeight(value))
    override val schedule
        : Optional[zio.aws.evidently.model.ExperimentSchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.evidently.model.ExperimentSchedule.wrap(value))
    override val segment: Optional[SegmentArn] = zio.aws.core.internal
      .optionalFromNullable(impl.segment())
      .map(value => zio.aws.evidently.model.primitives.SegmentArn(value))
    override val status: zio.aws.evidently.model.ExperimentStatus =
      zio.aws.evidently.model.ExperimentStatus.wrap(impl.status())
    override val statusReason: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val treatments
        : Optional[List[zio.aws.evidently.model.Treatment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.treatments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.Treatment.wrap(item)
          }.toList
        )
    override val `type`: zio.aws.evidently.model.ExperimentType =
      zio.aws.evidently.model.ExperimentType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.Experiment
  ): zio.aws.evidently.model.Experiment.ReadOnly = new Wrapper(impl)
}
