package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateSegmentResponse(
    segment: zio.aws.evidently.model.Segment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateSegmentResponse = {
    import CreateSegmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateSegmentResponse
      .builder()
      .segment(segment.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateSegmentResponse.ReadOnly =
    zio.aws.evidently.model.CreateSegmentResponse.wrap(buildAwsValue())
}
object CreateSegmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateSegmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateSegmentResponse =
      zio.aws.evidently.model.CreateSegmentResponse(segment.asEditable)
    def segment: zio.aws.evidently.model.Segment.ReadOnly
    def getSegment
        : ZIO[Any, Nothing, zio.aws.evidently.model.Segment.ReadOnly] =
      ZIO.succeed(segment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateSegmentResponse
  ) extends zio.aws.evidently.model.CreateSegmentResponse.ReadOnly {
    override val segment: zio.aws.evidently.model.Segment.ReadOnly =
      zio.aws.evidently.model.Segment.wrap(impl.segment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateSegmentResponse
  ): zio.aws.evidently.model.CreateSegmentResponse.ReadOnly = new Wrapper(impl)
}
