package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  SplitWeight,
  TagValue,
  ProjectRef,
  RandomizationSalt,
  Description,
  SegmentRef,
  ExperimentName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateExperimentRequest(
    description: Optional[Description] = Optional.Absent,
    metricGoals: Iterable[zio.aws.evidently.model.MetricGoalConfig],
    name: ExperimentName,
    onlineAbConfig: Optional[zio.aws.evidently.model.OnlineAbConfig] =
      Optional.Absent,
    project: ProjectRef,
    randomizationSalt: Optional[RandomizationSalt] = Optional.Absent,
    samplingRate: Optional[SplitWeight] = Optional.Absent,
    segment: Optional[SegmentRef] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    treatments: Iterable[zio.aws.evidently.model.TreatmentConfig]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateExperimentRequest = {
    import CreateExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateExperimentRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .metricGoals(metricGoals.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .name(ExperimentName.unwrap(name): java.lang.String)
      .optionallyWith(onlineAbConfig.map(value => value.buildAwsValue()))(
        _.onlineAbConfig
      )
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        randomizationSalt.map(value =>
          RandomizationSalt.unwrap(value): java.lang.String
        )
      )(_.randomizationSalt)
      .optionallyWith(
        samplingRate.map(value => SplitWeight.unwrap(value): java.lang.Long)
      )(_.samplingRate)
      .optionallyWith(
        segment.map(value => SegmentRef.unwrap(value): java.lang.String)
      )(_.segment)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .treatments(treatments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateExperimentRequest.ReadOnly =
    zio.aws.evidently.model.CreateExperimentRequest.wrap(buildAwsValue())
}
object CreateExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateExperimentRequest =
      zio.aws.evidently.model.CreateExperimentRequest(
        description.map(value => value),
        metricGoals.map { item =>
          item.asEditable
        },
        name,
        onlineAbConfig.map(value => value.asEditable),
        project,
        randomizationSalt.map(value => value),
        samplingRate.map(value => value),
        segment.map(value => value),
        tags.map(value => value),
        treatments.map { item =>
          item.asEditable
        }
      )
    def description: Optional[Description]
    def metricGoals: List[zio.aws.evidently.model.MetricGoalConfig.ReadOnly]
    def name: ExperimentName
    def onlineAbConfig
        : Optional[zio.aws.evidently.model.OnlineAbConfig.ReadOnly]
    def project: ProjectRef
    def randomizationSalt: Optional[RandomizationSalt]
    def samplingRate: Optional[SplitWeight]
    def segment: Optional[SegmentRef]
    def tags: Optional[Map[TagKey, TagValue]]
    def treatments: List[zio.aws.evidently.model.TreatmentConfig.ReadOnly]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMetricGoals: ZIO[Any, Nothing, List[
      zio.aws.evidently.model.MetricGoalConfig.ReadOnly
    ]] = ZIO.succeed(metricGoals)
    def getName: ZIO[Any, Nothing, ExperimentName] = ZIO.succeed(name)
    def getOnlineAbConfig
        : ZIO[Any, AwsError, zio.aws.evidently.model.OnlineAbConfig.ReadOnly] =
      AwsError.unwrapOptionField("onlineAbConfig", onlineAbConfig)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getRandomizationSalt: ZIO[Any, AwsError, RandomizationSalt] =
      AwsError.unwrapOptionField("randomizationSalt", randomizationSalt)
    def getSamplingRate: ZIO[Any, AwsError, SplitWeight] =
      AwsError.unwrapOptionField("samplingRate", samplingRate)
    def getSegment: ZIO[Any, AwsError, SegmentRef] =
      AwsError.unwrapOptionField("segment", segment)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTreatments: ZIO[Any, Nothing, List[
      zio.aws.evidently.model.TreatmentConfig.ReadOnly
    ]] = ZIO.succeed(treatments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateExperimentRequest
  ) extends zio.aws.evidently.model.CreateExperimentRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val metricGoals
        : List[zio.aws.evidently.model.MetricGoalConfig.ReadOnly] = impl
      .metricGoals()
      .asScala
      .map { item =>
        zio.aws.evidently.model.MetricGoalConfig.wrap(item)
      }
      .toList
    override val name: ExperimentName =
      zio.aws.evidently.model.primitives.ExperimentName(impl.name())
    override val onlineAbConfig
        : Optional[zio.aws.evidently.model.OnlineAbConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onlineAbConfig())
        .map(value => zio.aws.evidently.model.OnlineAbConfig.wrap(value))
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val randomizationSalt: Optional[RandomizationSalt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.randomizationSalt())
        .map(value =>
          zio.aws.evidently.model.primitives.RandomizationSalt(value)
        )
    override val samplingRate: Optional[SplitWeight] = zio.aws.core.internal
      .optionalFromNullable(impl.samplingRate())
      .map(value => zio.aws.evidently.model.primitives.SplitWeight(value))
    override val segment: Optional[SegmentRef] = zio.aws.core.internal
      .optionalFromNullable(impl.segment())
      .map(value => zio.aws.evidently.model.primitives.SegmentRef(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val treatments
        : List[zio.aws.evidently.model.TreatmentConfig.ReadOnly] = impl
      .treatments()
      .asScala
      .map { item =>
        zio.aws.evidently.model.TreatmentConfig.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateExperimentRequest
  ): zio.aws.evidently.model.CreateExperimentRequest.ReadOnly = new Wrapper(
    impl
  )
}
