package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.ProjectRef
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchEvaluateFeatureRequest(
    project: ProjectRef,
    requests: Iterable[zio.aws.evidently.model.EvaluationRequest]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureRequest = {
    import BatchEvaluateFeatureRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureRequest
      .builder()
      .project(ProjectRef.unwrap(project): java.lang.String)
      .requests(requests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.BatchEvaluateFeatureRequest.ReadOnly =
    zio.aws.evidently.model.BatchEvaluateFeatureRequest.wrap(buildAwsValue())
}
object BatchEvaluateFeatureRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.BatchEvaluateFeatureRequest =
      zio.aws.evidently.model.BatchEvaluateFeatureRequest(
        project,
        requests.map { item =>
          item.asEditable
        }
      )
    def project: ProjectRef
    def requests: List[zio.aws.evidently.model.EvaluationRequest.ReadOnly]
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getRequests: ZIO[Any, Nothing, List[
      zio.aws.evidently.model.EvaluationRequest.ReadOnly
    ]] = ZIO.succeed(requests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureRequest
  ) extends zio.aws.evidently.model.BatchEvaluateFeatureRequest.ReadOnly {
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val requests
        : List[zio.aws.evidently.model.EvaluationRequest.ReadOnly] = impl
      .requests()
      .asScala
      .map { item =>
        zio.aws.evidently.model.EvaluationRequest.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureRequest
  ): zio.aws.evidently.model.BatchEvaluateFeatureRequest.ReadOnly = new Wrapper(
    impl
  )
}
