package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  VariableValueStringValueString,
  VariableValueLongValueLong
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VariableValue(
    boolValue: Optional[Boolean] = Optional.Absent,
    doubleValue: Optional[Double] = Optional.Absent,
    longValue: Optional[VariableValueLongValueLong] = Optional.Absent,
    stringValue: Optional[VariableValueStringValueString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.VariableValue = {
    import VariableValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.VariableValue
      .builder()
      .optionallyWith(boolValue.map(value => value: java.lang.Boolean))(
        _.boolValue
      )
      .optionallyWith(doubleValue.map(value => value: java.lang.Double))(
        _.doubleValue
      )
      .optionallyWith(
        longValue.map(value =>
          VariableValueLongValueLong.unwrap(value): java.lang.Long
        )
      )(_.longValue)
      .optionallyWith(
        stringValue.map(value =>
          VariableValueStringValueString.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.VariableValue.ReadOnly =
    zio.aws.evidently.model.VariableValue.wrap(buildAwsValue())
}
object VariableValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.VariableValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.VariableValue =
      zio.aws.evidently.model.VariableValue(
        boolValue.map(value => value),
        doubleValue.map(value => value),
        longValue.map(value => value),
        stringValue.map(value => value)
      )
    def boolValue: Optional[Boolean]
    def doubleValue: Optional[Double]
    def longValue: Optional[VariableValueLongValueLong]
    def stringValue: Optional[VariableValueStringValueString]
    def getBoolValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("boolValue", boolValue)
    def getDoubleValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getLongValue: ZIO[Any, AwsError, VariableValueLongValueLong] =
      AwsError.unwrapOptionField("longValue", longValue)
    def getStringValue: ZIO[Any, AwsError, VariableValueStringValueString] =
      AwsError.unwrapOptionField("stringValue", stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.VariableValue
  ) extends zio.aws.evidently.model.VariableValue.ReadOnly {
    override val boolValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.boolValue())
      .map(value => value: Boolean)
    override val doubleValue: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.doubleValue())
      .map(value => value: Double)
    override val longValue: Optional[VariableValueLongValueLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.longValue())
        .map(value =>
          zio.aws.evidently.model.primitives.VariableValueLongValueLong(value)
        )
    override val stringValue: Optional[VariableValueStringValueString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringValue())
        .map(value =>
          zio.aws.evidently.model.primitives
            .VariableValueStringValueString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.VariableValue
  ): zio.aws.evidently.model.VariableValue.ReadOnly = new Wrapper(impl)
}
