package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  SplitWeight,
  ProjectRef,
  RandomizationSalt,
  Description,
  ExperimentName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateExperimentRequest(
    description: Optional[Description] = Optional.Absent,
    experiment: ExperimentName,
    metricGoals: Optional[Iterable[zio.aws.evidently.model.MetricGoalConfig]] =
      Optional.Absent,
    onlineAbConfig: Optional[zio.aws.evidently.model.OnlineAbConfig] =
      Optional.Absent,
    project: ProjectRef,
    randomizationSalt: Optional[RandomizationSalt] = Optional.Absent,
    samplingRate: Optional[SplitWeight] = Optional.Absent,
    treatments: Optional[Iterable[zio.aws.evidently.model.TreatmentConfig]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UpdateExperimentRequest = {
    import UpdateExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UpdateExperimentRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .experiment(ExperimentName.unwrap(experiment): java.lang.String)
      .optionallyWith(
        metricGoals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricGoals)
      .optionallyWith(onlineAbConfig.map(value => value.buildAwsValue()))(
        _.onlineAbConfig
      )
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        randomizationSalt.map(value =>
          RandomizationSalt.unwrap(value): java.lang.String
        )
      )(_.randomizationSalt)
      .optionallyWith(
        samplingRate.map(value => SplitWeight.unwrap(value): java.lang.Long)
      )(_.samplingRate)
      .optionallyWith(
        treatments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.treatments)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.UpdateExperimentRequest.ReadOnly =
    zio.aws.evidently.model.UpdateExperimentRequest.wrap(buildAwsValue())
}
object UpdateExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UpdateExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UpdateExperimentRequest =
      zio.aws.evidently.model.UpdateExperimentRequest(
        description.map(value => value),
        experiment,
        metricGoals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onlineAbConfig.map(value => value.asEditable),
        project,
        randomizationSalt.map(value => value),
        samplingRate.map(value => value),
        treatments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Optional[Description]
    def experiment: ExperimentName
    def metricGoals
        : Optional[List[zio.aws.evidently.model.MetricGoalConfig.ReadOnly]]
    def onlineAbConfig
        : Optional[zio.aws.evidently.model.OnlineAbConfig.ReadOnly]
    def project: ProjectRef
    def randomizationSalt: Optional[RandomizationSalt]
    def samplingRate: Optional[SplitWeight]
    def treatments
        : Optional[List[zio.aws.evidently.model.TreatmentConfig.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getExperiment: ZIO[Any, Nothing, ExperimentName] =
      ZIO.succeed(experiment)
    def getMetricGoals: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.MetricGoalConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("metricGoals", metricGoals)
    def getOnlineAbConfig
        : ZIO[Any, AwsError, zio.aws.evidently.model.OnlineAbConfig.ReadOnly] =
      AwsError.unwrapOptionField("onlineAbConfig", onlineAbConfig)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getRandomizationSalt: ZIO[Any, AwsError, RandomizationSalt] =
      AwsError.unwrapOptionField("randomizationSalt", randomizationSalt)
    def getSamplingRate: ZIO[Any, AwsError, SplitWeight] =
      AwsError.unwrapOptionField("samplingRate", samplingRate)
    def getTreatments: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.TreatmentConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("treatments", treatments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UpdateExperimentRequest
  ) extends zio.aws.evidently.model.UpdateExperimentRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val experiment: ExperimentName =
      zio.aws.evidently.model.primitives.ExperimentName(impl.experiment())
    override val metricGoals
        : Optional[List[zio.aws.evidently.model.MetricGoalConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricGoals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.MetricGoalConfig.wrap(item)
          }.toList
        )
    override val onlineAbConfig
        : Optional[zio.aws.evidently.model.OnlineAbConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onlineAbConfig())
        .map(value => zio.aws.evidently.model.OnlineAbConfig.wrap(value))
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val randomizationSalt: Optional[RandomizationSalt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.randomizationSalt())
        .map(value =>
          zio.aws.evidently.model.primitives.RandomizationSalt(value)
        )
    override val samplingRate: Optional[SplitWeight] = zio.aws.core.internal
      .optionalFromNullable(impl.samplingRate())
      .map(value => zio.aws.evidently.model.primitives.SplitWeight(value))
    override val treatments
        : Optional[List[zio.aws.evidently.model.TreatmentConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.treatments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.TreatmentConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UpdateExperimentRequest
  ): zio.aws.evidently.model.UpdateExperimentRequest.ReadOnly = new Wrapper(
    impl
  )
}
