package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  TreatmentName,
  VariationName,
  FeatureName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Treatment(
    description: Optional[Description] = Optional.Absent,
    featureVariations: Optional[Map[FeatureName, VariationName]] =
      Optional.Absent,
    name: TreatmentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.Treatment = {
    import Treatment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.Treatment
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        featureVariations.map(value =>
          value
            .map({ case (key, value) =>
              (FeatureName.unwrap(key): java.lang.String) -> (VariationName
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.featureVariations)
      .name(TreatmentName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.Treatment.ReadOnly =
    zio.aws.evidently.model.Treatment.wrap(buildAwsValue())
}
object Treatment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.Treatment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.Treatment =
      zio.aws.evidently.model.Treatment(
        description.map(value => value),
        featureVariations.map(value => value),
        name
      )
    def description: Optional[Description]
    def featureVariations: Optional[Map[FeatureName, VariationName]]
    def name: TreatmentName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFeatureVariations
        : ZIO[Any, AwsError, Map[FeatureName, VariationName]] =
      AwsError.unwrapOptionField("featureVariations", featureVariations)
    def getName: ZIO[Any, Nothing, TreatmentName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.Treatment
  ) extends zio.aws.evidently.model.Treatment.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val featureVariations: Optional[Map[FeatureName, VariationName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureVariations())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.evidently.model.primitives.FeatureName(
                key
              ) -> zio.aws.evidently.model.primitives.VariationName(value)
            })
            .toMap
        )
    override val name: TreatmentName =
      zio.aws.evidently.model.primitives.TreatmentName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.Treatment
  ): zio.aws.evidently.model.Treatment.ReadOnly = new Wrapper(impl)
}
