package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MetricMonitorConfig(
    metricDefinition: zio.aws.evidently.model.MetricDefinitionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.MetricMonitorConfig = {
    import MetricMonitorConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.MetricMonitorConfig
      .builder()
      .metricDefinition(metricDefinition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.MetricMonitorConfig.ReadOnly =
    zio.aws.evidently.model.MetricMonitorConfig.wrap(buildAwsValue())
}
object MetricMonitorConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.MetricMonitorConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.MetricMonitorConfig =
      zio.aws.evidently.model.MetricMonitorConfig(metricDefinition.asEditable)
    def metricDefinition
        : zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly
    def getMetricDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly
    ] = ZIO.succeed(metricDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.MetricMonitorConfig
  ) extends zio.aws.evidently.model.MetricMonitorConfig.ReadOnly {
    override val metricDefinition
        : zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly =
      zio.aws.evidently.model.MetricDefinitionConfig
        .wrap(impl.metricDefinition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.MetricMonitorConfig
  ): zio.aws.evidently.model.MetricMonitorConfig.ReadOnly = new Wrapper(impl)
}
