package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  VariationName,
  GroupName,
  FeatureName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LaunchGroupConfig(
    description: Optional[Description] = Optional.Absent,
    feature: FeatureName,
    name: GroupName,
    variation: VariationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.LaunchGroupConfig = {
    import LaunchGroupConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.LaunchGroupConfig
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .feature(FeatureName.unwrap(feature): java.lang.String)
      .name(GroupName.unwrap(name): java.lang.String)
      .variation(VariationName.unwrap(variation): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.LaunchGroupConfig.ReadOnly =
    zio.aws.evidently.model.LaunchGroupConfig.wrap(buildAwsValue())
}
object LaunchGroupConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.LaunchGroupConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.LaunchGroupConfig =
      zio.aws.evidently.model.LaunchGroupConfig(
        description.map(value => value),
        feature,
        name,
        variation
      )
    def description: Optional[Description]
    def feature: FeatureName
    def name: GroupName
    def variation: VariationName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFeature: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(feature)
    def getName: ZIO[Any, Nothing, GroupName] = ZIO.succeed(name)
    def getVariation: ZIO[Any, Nothing, VariationName] = ZIO.succeed(variation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.LaunchGroupConfig
  ) extends zio.aws.evidently.model.LaunchGroupConfig.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val feature: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.feature())
    override val name: GroupName =
      zio.aws.evidently.model.primitives.GroupName(impl.name())
    override val variation: VariationName =
      zio.aws.evidently.model.primitives.VariationName(impl.variation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.LaunchGroupConfig
  ): zio.aws.evidently.model.LaunchGroupConfig.ReadOnly = new Wrapper(impl)
}
