package zio.aws.evidently.model
import scala.jdk.CollectionConverters.*
sealed trait ExperimentResultRequestType {
  def unwrap: software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType
}
object ExperimentResultRequestType {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType
  ): zio.aws.evidently.model.ExperimentResultRequestType = value match {
    case software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType.BASE_STAT =>
      val r = BaseStat
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType.TREATMENT_EFFECT =>
      val r = TreatmentEffect
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType.CONFIDENCE_INTERVAL =>
      val r = ConfidenceInterval
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType.P_VALUE =>
      val r = PValue
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.ExperimentResultRequestType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType.UNKNOWN_TO_SDK_VERSION
  }
  case object BaseStat
      extends zio.aws.evidently.model.ExperimentResultRequestType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType.BASE_STAT
  }
  case object TreatmentEffect
      extends zio.aws.evidently.model.ExperimentResultRequestType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType.TREATMENT_EFFECT
  }
  case object ConfidenceInterval
      extends zio.aws.evidently.model.ExperimentResultRequestType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType.CONFIDENCE_INTERVAL
  }
  case object PValue
      extends zio.aws.evidently.model.ExperimentResultRequestType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType.P_VALUE
  }
}
