package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  ProjectRef,
  FeatureName,
  JsonValue,
  EntityId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluateFeatureRequest(
    entityId: EntityId,
    evaluationContext: Optional[JsonValue] = Optional.Absent,
    feature: FeatureName,
    project: ProjectRef
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.EvaluateFeatureRequest = {
    import EvaluateFeatureRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.EvaluateFeatureRequest
      .builder()
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .optionallyWith(
        evaluationContext.map(value =>
          JsonValue.unwrap(value): java.lang.String
        )
      )(_.evaluationContext)
      .feature(FeatureName.unwrap(feature): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.EvaluateFeatureRequest.ReadOnly =
    zio.aws.evidently.model.EvaluateFeatureRequest.wrap(buildAwsValue())
}
object EvaluateFeatureRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.EvaluateFeatureRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.EvaluateFeatureRequest =
      zio.aws.evidently.model.EvaluateFeatureRequest(
        entityId,
        evaluationContext.map(value => value),
        feature,
        project
      )
    def entityId: EntityId
    def evaluationContext: Optional[JsonValue]
    def feature: FeatureName
    def project: ProjectRef
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getEvaluationContext: ZIO[Any, AwsError, JsonValue] =
      AwsError.unwrapOptionField("evaluationContext", evaluationContext)
    def getFeature: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(feature)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.EvaluateFeatureRequest
  ) extends zio.aws.evidently.model.EvaluateFeatureRequest.ReadOnly {
    override val entityId: EntityId =
      zio.aws.evidently.model.primitives.EntityId(impl.entityId())
    override val evaluationContext: Optional[JsonValue] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationContext())
      .map(value => zio.aws.evidently.model.primitives.JsonValue(value))
    override val feature: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.feature())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.EvaluateFeatureRequest
  ): zio.aws.evidently.model.EvaluateFeatureRequest.ReadOnly = new Wrapper(impl)
}
