package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.CwLogGroupSafeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CloudWatchLogsDestination(
    logGroup: Optional[CwLogGroupSafeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination = {
    import CloudWatchLogsDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination
      .builder()
      .optionallyWith(
        logGroup.map(value =>
          CwLogGroupSafeName.unwrap(value): java.lang.String
        )
      )(_.logGroup)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly =
    zio.aws.evidently.model.CloudWatchLogsDestination.wrap(buildAwsValue())
}
object CloudWatchLogsDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CloudWatchLogsDestination =
      zio.aws.evidently.model
        .CloudWatchLogsDestination(logGroup.map(value => value))
    def logGroup: Optional[CwLogGroupSafeName]
    def getLogGroup: ZIO[Any, AwsError, CwLogGroupSafeName] =
      AwsError.unwrapOptionField("logGroup", logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination
  ) extends zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly {
    override val logGroup: Optional[CwLogGroupSafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroup())
      .map(value =>
        zio.aws.evidently.model.primitives.CwLogGroupSafeName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination
  ): zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly = new Wrapper(
    impl
  )
}
