package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateFeatureResponse(
    feature: zio.aws.evidently.model.Feature
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UpdateFeatureResponse = {
    import UpdateFeatureResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UpdateFeatureResponse
      .builder()
      .feature(feature.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.UpdateFeatureResponse.ReadOnly =
    zio.aws.evidently.model.UpdateFeatureResponse.wrap(buildAwsValue())
}
object UpdateFeatureResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UpdateFeatureResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UpdateFeatureResponse =
      zio.aws.evidently.model.UpdateFeatureResponse(feature.asEditable)
    def feature: zio.aws.evidently.model.Feature.ReadOnly
    def getFeature
        : ZIO[Any, Nothing, zio.aws.evidently.model.Feature.ReadOnly] =
      ZIO.succeed(feature)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UpdateFeatureResponse
  ) extends zio.aws.evidently.model.UpdateFeatureResponse.ReadOnly {
    override val feature: zio.aws.evidently.model.Feature.ReadOnly =
      zio.aws.evidently.model.Feature.wrap(impl.feature())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UpdateFeatureResponse
  ): zio.aws.evidently.model.UpdateFeatureResponse.ReadOnly = new Wrapper(impl)
}
