package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{S3PrefixSafeName, S3BucketSafeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3DestinationConfig(
    bucket: Optional[S3BucketSafeName] = Optional.Absent,
    prefix: Optional[S3PrefixSafeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.S3DestinationConfig = {
    import S3DestinationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.S3DestinationConfig
      .builder()
      .optionallyWith(
        bucket.map(value => S3BucketSafeName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        prefix.map(value => S3PrefixSafeName.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.S3DestinationConfig.ReadOnly =
    zio.aws.evidently.model.S3DestinationConfig.wrap(buildAwsValue())
}
object S3DestinationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.S3DestinationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.S3DestinationConfig =
      zio.aws.evidently.model.S3DestinationConfig(
        bucket.map(value => value),
        prefix.map(value => value)
      )
    def bucket: Optional[S3BucketSafeName]
    def prefix: Optional[S3PrefixSafeName]
    def getBucket: ZIO[Any, AwsError, S3BucketSafeName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getPrefix: ZIO[Any, AwsError, S3PrefixSafeName] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.S3DestinationConfig
  ) extends zio.aws.evidently.model.S3DestinationConfig.ReadOnly {
    override val bucket: Optional[S3BucketSafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.evidently.model.primitives.S3BucketSafeName(value))
    override val prefix: Optional[S3PrefixSafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.evidently.model.primitives.S3PrefixSafeName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.S3DestinationConfig
  ): zio.aws.evidently.model.S3DestinationConfig.ReadOnly = new Wrapper(impl)
}
