package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MetricMonitor(
    metricDefinition: zio.aws.evidently.model.MetricDefinition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.MetricMonitor = {
    import MetricMonitor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.MetricMonitor
      .builder()
      .metricDefinition(metricDefinition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.MetricMonitor.ReadOnly =
    zio.aws.evidently.model.MetricMonitor.wrap(buildAwsValue())
}
object MetricMonitor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.MetricMonitor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.MetricMonitor =
      zio.aws.evidently.model.MetricMonitor(metricDefinition.asEditable)
    def metricDefinition: zio.aws.evidently.model.MetricDefinition.ReadOnly
    def getMetricDefinition
        : ZIO[Any, Nothing, zio.aws.evidently.model.MetricDefinition.ReadOnly] =
      ZIO.succeed(metricDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.MetricMonitor
  ) extends zio.aws.evidently.model.MetricMonitor.ReadOnly {
    override val metricDefinition
        : zio.aws.evidently.model.MetricDefinition.ReadOnly =
      zio.aws.evidently.model.MetricDefinition.wrap(impl.metricDefinition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.MetricMonitor
  ): zio.aws.evidently.model.MetricMonitor.ReadOnly = new Wrapper(impl)
}
