package zio.aws.evidently.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.{
  ProjectRef,
  NextToken,
  MaxExperiments
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListExperimentsRequest(
    maxResults: Optional[MaxExperiments] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    project: ProjectRef,
    status: Optional[zio.aws.evidently.model.ExperimentStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListExperimentsRequest = {
    import ListExperimentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListExperimentsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxExperiments.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListExperimentsRequest.ReadOnly =
    zio.aws.evidently.model.ListExperimentsRequest.wrap(buildAwsValue())
}
object ListExperimentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListExperimentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListExperimentsRequest =
      zio.aws.evidently.model.ListExperimentsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        project,
        status.map(value => value)
      )
    def maxResults: Optional[MaxExperiments]
    def nextToken: Optional[NextToken]
    def project: ProjectRef
    def status: Optional[zio.aws.evidently.model.ExperimentStatus]
    def getMaxResults: ZIO[Any, AwsError, MaxExperiments] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.evidently.model.ExperimentStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListExperimentsRequest
  ) extends zio.aws.evidently.model.ListExperimentsRequest.ReadOnly {
    override val maxResults: Optional[MaxExperiments] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.evidently.model.primitives.MaxExperiments(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val status: Optional[zio.aws.evidently.model.ExperimentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.evidently.model.ExperimentStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListExperimentsRequest
  ): zio.aws.evidently.model.ListExperimentsRequest.ReadOnly = new Wrapper(impl)
}
