package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{ProjectRef, LaunchName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLaunchRequest(launch: LaunchName, project: ProjectRef) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetLaunchRequest = {
    import GetLaunchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetLaunchRequest
      .builder()
      .launch(LaunchName.unwrap(launch): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetLaunchRequest.ReadOnly =
    zio.aws.evidently.model.GetLaunchRequest.wrap(buildAwsValue())
}
object GetLaunchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetLaunchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetLaunchRequest =
      zio.aws.evidently.model.GetLaunchRequest(launch, project)
    def launch: LaunchName
    def project: ProjectRef
    def getLaunch: ZIO[Any, Nothing, LaunchName] = ZIO.succeed(launch)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetLaunchRequest
  ) extends zio.aws.evidently.model.GetLaunchRequest.ReadOnly {
    override val launch: LaunchName =
      zio.aws.evidently.model.primitives.LaunchName(impl.launch())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetLaunchRequest
  ): zio.aws.evidently.model.GetLaunchRequest.ReadOnly = new Wrapper(impl)
}
