package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  TreatmentName,
  CwDimensionSafeName,
  JsonValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExperimentReport(
    content: Optional[JsonValue] = Optional.Absent,
    metricName: Optional[CwDimensionSafeName] = Optional.Absent,
    reportName: Optional[zio.aws.evidently.model.ExperimentReportName] =
      Optional.Absent,
    treatmentName: Optional[TreatmentName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ExperimentReport = {
    import ExperimentReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ExperimentReport
      .builder()
      .optionallyWith(
        content.map(value => JsonValue.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metricName.map(value =>
          CwDimensionSafeName.unwrap(value): java.lang.String
        )
      )(_.metricName)
      .optionallyWith(reportName.map(value => value.unwrap))(_.reportName)
      .optionallyWith(
        treatmentName.map(value =>
          TreatmentName.unwrap(value): java.lang.String
        )
      )(_.treatmentName)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ExperimentReport.ReadOnly =
    zio.aws.evidently.model.ExperimentReport.wrap(buildAwsValue())
}
object ExperimentReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ExperimentReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ExperimentReport =
      zio.aws.evidently.model.ExperimentReport(
        content.map(value => value),
        metricName.map(value => value),
        reportName.map(value => value),
        treatmentName.map(value => value)
      )
    def content: Optional[JsonValue]
    def metricName: Optional[CwDimensionSafeName]
    def reportName: Optional[zio.aws.evidently.model.ExperimentReportName]
    def treatmentName: Optional[TreatmentName]
    def getContent: ZIO[Any, AwsError, JsonValue] =
      AwsError.unwrapOptionField("content", content)
    def getMetricName: ZIO[Any, AwsError, CwDimensionSafeName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getReportName
        : ZIO[Any, AwsError, zio.aws.evidently.model.ExperimentReportName] =
      AwsError.unwrapOptionField("reportName", reportName)
    def getTreatmentName: ZIO[Any, AwsError, TreatmentName] =
      AwsError.unwrapOptionField("treatmentName", treatmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ExperimentReport
  ) extends zio.aws.evidently.model.ExperimentReport.ReadOnly {
    override val content: Optional[JsonValue] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.evidently.model.primitives.JsonValue(value))
    override val metricName: Optional[CwDimensionSafeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricName())
        .map(value =>
          zio.aws.evidently.model.primitives.CwDimensionSafeName(value)
        )
    override val reportName
        : Optional[zio.aws.evidently.model.ExperimentReportName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportName())
        .map(value => zio.aws.evidently.model.ExperimentReportName.wrap(value))
    override val treatmentName: Optional[TreatmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.treatmentName())
      .map(value => zio.aws.evidently.model.primitives.TreatmentName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ExperimentReport
  ): zio.aws.evidently.model.ExperimentReport.ReadOnly = new Wrapper(impl)
}
