package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutProjectEventsResponse(
    eventResults: Optional[
      Iterable[zio.aws.evidently.model.PutProjectEventsResultEntry]
    ] = Optional.Absent,
    failedEventCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse = {
    import PutProjectEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse
      .builder()
      .optionallyWith(
        eventResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventResults)
      .optionallyWith(failedEventCount.map(value => value: java.lang.Integer))(
        _.failedEventCount
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly =
    zio.aws.evidently.model.PutProjectEventsResponse.wrap(buildAwsValue())
}
object PutProjectEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.PutProjectEventsResponse =
      zio.aws.evidently.model.PutProjectEventsResponse(
        eventResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failedEventCount.map(value => value)
      )
    def eventResults: Optional[
      List[zio.aws.evidently.model.PutProjectEventsResultEntry.ReadOnly]
    ]
    def failedEventCount: Optional[Integer]
    def getEventResults: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.PutProjectEventsResultEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("eventResults", eventResults)
    def getFailedEventCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedEventCount", failedEventCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse
  ) extends zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly {
    override val eventResults: Optional[
      List[zio.aws.evidently.model.PutProjectEventsResultEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.PutProjectEventsResultEntry.wrap(item)
        }.toList
      )
    override val failedEventCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedEventCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse
  ): zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly = new Wrapper(
    impl
  )
}
