package zio.aws.evidently.model
import scala.jdk.CollectionConverters.*
sealed trait LaunchStatus {
  def unwrap: software.amazon.awssdk.services.evidently.model.LaunchStatus
}
object LaunchStatus {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.LaunchStatus
  ): zio.aws.evidently.model.LaunchStatus = value match {
    case software.amazon.awssdk.services.evidently.model.LaunchStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.LaunchStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.evidently.model.LaunchStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.evidently.model.LaunchStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.evidently.model.LaunchStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.evidently.model.LaunchStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.evidently.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchStatus =
      software.amazon.awssdk.services.evidently.model.LaunchStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.evidently.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchStatus =
      software.amazon.awssdk.services.evidently.model.LaunchStatus.CREATED
  }
  case object UPDATING extends zio.aws.evidently.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchStatus =
      software.amazon.awssdk.services.evidently.model.LaunchStatus.UPDATING
  }
  case object RUNNING extends zio.aws.evidently.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchStatus =
      software.amazon.awssdk.services.evidently.model.LaunchStatus.RUNNING
  }
  case object COMPLETED extends zio.aws.evidently.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchStatus =
      software.amazon.awssdk.services.evidently.model.LaunchStatus.COMPLETED
  }
  case object CANCELLED extends zio.aws.evidently.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchStatus =
      software.amazon.awssdk.services.evidently.model.LaunchStatus.CANCELLED
  }
}
