package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateProjectResponse(
    project: zio.aws.evidently.model.Project
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateProjectResponse = {
    import CreateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateProjectResponse
      .builder()
      .project(project.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateProjectResponse.ReadOnly =
    zio.aws.evidently.model.CreateProjectResponse.wrap(buildAwsValue())
}
object CreateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateProjectResponse =
      zio.aws.evidently.model.CreateProjectResponse(project.asEditable)
    def project: zio.aws.evidently.model.Project.ReadOnly
    def getProject
        : ZIO[Any, Nothing, zio.aws.evidently.model.Project.ReadOnly] =
      ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateProjectResponse
  ) extends zio.aws.evidently.model.CreateProjectResponse.ReadOnly {
    override val project: zio.aws.evidently.model.Project.ReadOnly =
      zio.aws.evidently.model.Project.wrap(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateProjectResponse
  ): zio.aws.evidently.model.CreateProjectResponse.ReadOnly = new Wrapper(impl)
}
