package zio.aws.evidently.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.{ProjectRef, NextToken, MaxFeatures}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFeaturesRequest(
    maxResults: Optional[MaxFeatures] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    project: ProjectRef
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListFeaturesRequest = {
    import ListFeaturesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListFeaturesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxFeatures.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListFeaturesRequest.ReadOnly =
    zio.aws.evidently.model.ListFeaturesRequest.wrap(buildAwsValue())
}
object ListFeaturesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListFeaturesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListFeaturesRequest =
      zio.aws.evidently.model.ListFeaturesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        project
      )
    def maxResults: Optional[MaxFeatures]
    def nextToken: Optional[NextToken]
    def project: ProjectRef
    def getMaxResults: ZIO[Any, AwsError, MaxFeatures] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListFeaturesRequest
  ) extends zio.aws.evidently.model.ListFeaturesRequest.ReadOnly {
    override val maxResults: Optional[MaxFeatures] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.evidently.model.primitives.MaxFeatures(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListFeaturesRequest
  ): zio.aws.evidently.model.ListFeaturesRequest.ReadOnly = new Wrapper(impl)
}
