package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  TagValue,
  ProjectRef,
  RandomizationSalt,
  Description,
  LaunchName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLaunchRequest(
    description: Optional[Description] = Optional.Absent,
    groups: Iterable[zio.aws.evidently.model.LaunchGroupConfig],
    metricMonitors: Optional[
      Iterable[zio.aws.evidently.model.MetricMonitorConfig]
    ] = Optional.Absent,
    name: LaunchName,
    project: ProjectRef,
    randomizationSalt: Optional[RandomizationSalt] = Optional.Absent,
    scheduledSplitsConfig: Optional[
      zio.aws.evidently.model.ScheduledSplitsLaunchConfig
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateLaunchRequest = {
    import CreateLaunchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateLaunchRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .groups(groups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        metricMonitors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricMonitors)
      .name(LaunchName.unwrap(name): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        randomizationSalt.map(value =>
          RandomizationSalt.unwrap(value): java.lang.String
        )
      )(_.randomizationSalt)
      .optionallyWith(
        scheduledSplitsConfig.map(value => value.buildAwsValue())
      )(_.scheduledSplitsConfig)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateLaunchRequest.ReadOnly =
    zio.aws.evidently.model.CreateLaunchRequest.wrap(buildAwsValue())
}
object CreateLaunchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateLaunchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateLaunchRequest =
      zio.aws.evidently.model.CreateLaunchRequest(
        description.map(value => value),
        groups.map { item =>
          item.asEditable
        },
        metricMonitors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name,
        project,
        randomizationSalt.map(value => value),
        scheduledSplitsConfig.map(value => value.asEditable),
        tags.map(value => value)
      )
    def description: Optional[Description]
    def groups: List[zio.aws.evidently.model.LaunchGroupConfig.ReadOnly]
    def metricMonitors
        : Optional[List[zio.aws.evidently.model.MetricMonitorConfig.ReadOnly]]
    def name: LaunchName
    def project: ProjectRef
    def randomizationSalt: Optional[RandomizationSalt]
    def scheduledSplitsConfig
        : Optional[zio.aws.evidently.model.ScheduledSplitsLaunchConfig.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getGroups: ZIO[Any, Nothing, List[
      zio.aws.evidently.model.LaunchGroupConfig.ReadOnly
    ]] = ZIO.succeed(groups)
    def getMetricMonitors: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.MetricMonitorConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("metricMonitors", metricMonitors)
    def getName: ZIO[Any, Nothing, LaunchName] = ZIO.succeed(name)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getRandomizationSalt: ZIO[Any, AwsError, RandomizationSalt] =
      AwsError.unwrapOptionField("randomizationSalt", randomizationSalt)
    def getScheduledSplitsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ScheduledSplitsLaunchConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("scheduledSplitsConfig", scheduledSplitsConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateLaunchRequest
  ) extends zio.aws.evidently.model.CreateLaunchRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val groups
        : List[zio.aws.evidently.model.LaunchGroupConfig.ReadOnly] = impl
      .groups()
      .asScala
      .map { item =>
        zio.aws.evidently.model.LaunchGroupConfig.wrap(item)
      }
      .toList
    override val metricMonitors
        : Optional[List[zio.aws.evidently.model.MetricMonitorConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricMonitors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.MetricMonitorConfig.wrap(item)
          }.toList
        )
    override val name: LaunchName =
      zio.aws.evidently.model.primitives.LaunchName(impl.name())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val randomizationSalt: Optional[RandomizationSalt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.randomizationSalt())
        .map(value =>
          zio.aws.evidently.model.primitives.RandomizationSalt(value)
        )
    override val scheduledSplitsConfig: Optional[
      zio.aws.evidently.model.ScheduledSplitsLaunchConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledSplitsConfig())
      .map(value =>
        zio.aws.evidently.model.ScheduledSplitsLaunchConfig.wrap(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateLaunchRequest
  ): zio.aws.evidently.model.CreateLaunchRequest.ReadOnly = new Wrapper(impl)
}
