package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateExperimentResponse(
    experiment: zio.aws.evidently.model.Experiment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateExperimentResponse = {
    import CreateExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateExperimentResponse
      .builder()
      .experiment(experiment.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateExperimentResponse.ReadOnly =
    zio.aws.evidently.model.CreateExperimentResponse.wrap(buildAwsValue())
}
object CreateExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateExperimentResponse =
      zio.aws.evidently.model.CreateExperimentResponse(experiment.asEditable)
    def experiment: zio.aws.evidently.model.Experiment.ReadOnly
    def getExperiment
        : ZIO[Any, Nothing, zio.aws.evidently.model.Experiment.ReadOnly] =
      ZIO.succeed(experiment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateExperimentResponse
  ) extends zio.aws.evidently.model.CreateExperimentResponse.ReadOnly {
    override val experiment: zio.aws.evidently.model.Experiment.ReadOnly =
      zio.aws.evidently.model.Experiment.wrap(impl.experiment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateExperimentResponse
  ): zio.aws.evidently.model.CreateExperimentResponse.ReadOnly = new Wrapper(
    impl
  )
}
