package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.VariationName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Variation(
    name: Option[VariationName] = None,
    value: Option[zio.aws.evidently.model.VariableValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.Variation = {
    import Variation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.Variation
      .builder()
      .optionallyWith(
        name.map(value => VariationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.Variation.ReadOnly =
    zio.aws.evidently.model.Variation.wrap(buildAwsValue())
}
object Variation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.Variation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.Variation = zio.aws.evidently.model
      .Variation(name.map(value => value), value.map(value => value.asEditable))
    def name: Option[VariationName]
    def value: Option[zio.aws.evidently.model.VariableValue.ReadOnly]
    def getName: ZIO[Any, AwsError, VariationName] =
      AwsError.unwrapOptionField("name", name)
    def getValue
        : ZIO[Any, AwsError, zio.aws.evidently.model.VariableValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.Variation
  ) extends zio.aws.evidently.model.Variation.ReadOnly {
    override val name: Option[VariationName] = scala
      .Option(impl.name())
      .map(value => zio.aws.evidently.model.primitives.VariationName(value))
    override val value: Option[zio.aws.evidently.model.VariableValue.ReadOnly] =
      scala
        .Option(impl.value())
        .map(value => zio.aws.evidently.model.VariableValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.Variation
  ): zio.aws.evidently.model.Variation.ReadOnly = new Wrapper(impl)
}
