package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  VariableValueStringValueString,
  VariableValueLongValueLong
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VariableValue(
    boolValue: Option[Boolean] = None,
    doubleValue: Option[Double] = None,
    longValue: Option[VariableValueLongValueLong] = None,
    stringValue: Option[VariableValueStringValueString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.VariableValue = {
    import VariableValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.VariableValue
      .builder()
      .optionallyWith(boolValue.map(value => value: java.lang.Boolean))(
        _.boolValue
      )
      .optionallyWith(doubleValue.map(value => value: java.lang.Double))(
        _.doubleValue
      )
      .optionallyWith(
        longValue.map(value =>
          VariableValueLongValueLong.unwrap(value): java.lang.Long
        )
      )(_.longValue)
      .optionallyWith(
        stringValue.map(value =>
          VariableValueStringValueString.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.VariableValue.ReadOnly =
    zio.aws.evidently.model.VariableValue.wrap(buildAwsValue())
}
object VariableValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.VariableValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.VariableValue =
      zio.aws.evidently.model.VariableValue(
        boolValue.map(value => value),
        doubleValue.map(value => value),
        longValue.map(value => value),
        stringValue.map(value => value)
      )
    def boolValue: Option[Boolean]
    def doubleValue: Option[Double]
    def longValue: Option[VariableValueLongValueLong]
    def stringValue: Option[VariableValueStringValueString]
    def getBoolValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("boolValue", boolValue)
    def getDoubleValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getLongValue: ZIO[Any, AwsError, VariableValueLongValueLong] =
      AwsError.unwrapOptionField("longValue", longValue)
    def getStringValue: ZIO[Any, AwsError, VariableValueStringValueString] =
      AwsError.unwrapOptionField("stringValue", stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.VariableValue
  ) extends zio.aws.evidently.model.VariableValue.ReadOnly {
    override val boolValue: Option[Boolean] =
      scala.Option(impl.boolValue()).map(value => value: Boolean)
    override val doubleValue: Option[Double] =
      scala.Option(impl.doubleValue()).map(value => value: Double)
    override val longValue: Option[VariableValueLongValueLong] = scala
      .Option(impl.longValue())
      .map(value =>
        zio.aws.evidently.model.primitives.VariableValueLongValueLong(value)
      )
    override val stringValue: Option[VariableValueStringValueString] = scala
      .Option(impl.stringValue())
      .map(value =>
        zio.aws.evidently.model.primitives.VariableValueStringValueString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.VariableValue
  ): zio.aws.evidently.model.VariableValue.ReadOnly = new Wrapper(impl)
}
