package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  Description,
  ProjectRef,
  ExperimentName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StopExperimentRequest(
    desiredState: Option[zio.aws.evidently.model.ExperimentStopDesiredState] =
      None,
    experiment: ExperimentName,
    project: ProjectRef,
    reason: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.StopExperimentRequest = {
    import StopExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.StopExperimentRequest
      .builder()
      .optionallyWith(desiredState.map(value => value.unwrap))(_.desiredState)
      .experiment(ExperimentName.unwrap(experiment): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        reason.map(value => Description.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.StopExperimentRequest.ReadOnly =
    zio.aws.evidently.model.StopExperimentRequest.wrap(buildAwsValue())
}
object StopExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.StopExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.StopExperimentRequest =
      zio.aws.evidently.model.StopExperimentRequest(
        desiredState.map(value => value),
        experiment,
        project,
        reason.map(value => value)
      )
    def desiredState: Option[zio.aws.evidently.model.ExperimentStopDesiredState]
    def experiment: ExperimentName
    def project: ProjectRef
    def reason: Option[Description]
    def getDesiredState: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ExperimentStopDesiredState
    ] = AwsError.unwrapOptionField("desiredState", desiredState)
    def getExperiment: ZIO[Any, Nothing, ExperimentName] =
      ZIO.succeed(experiment)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getReason: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.StopExperimentRequest
  ) extends zio.aws.evidently.model.StopExperimentRequest.ReadOnly {
    override val desiredState
        : Option[zio.aws.evidently.model.ExperimentStopDesiredState] = scala
      .Option(impl.desiredState())
      .map(value =>
        zio.aws.evidently.model.ExperimentStopDesiredState.wrap(value)
      )
    override val experiment: ExperimentName =
      zio.aws.evidently.model.primitives.ExperimentName(impl.experiment())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val reason: Option[Description] = scala
      .Option(impl.reason())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.StopExperimentRequest
  ): zio.aws.evidently.model.StopExperimentRequest.ReadOnly = new Wrapper(impl)
}
