package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{Uuid, ErrorMessage, ErrorCodeEnum}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutProjectEventsResultEntry(
    errorCode: Option[ErrorCodeEnum] = None,
    errorMessage: Option[ErrorMessage] = None,
    eventId: Option[Uuid] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.PutProjectEventsResultEntry = {
    import PutProjectEventsResultEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.PutProjectEventsResultEntry
      .builder()
      .optionallyWith(
        errorCode.map(value => ErrorCodeEnum.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        eventId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.eventId)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.PutProjectEventsResultEntry.ReadOnly =
    zio.aws.evidently.model.PutProjectEventsResultEntry.wrap(buildAwsValue())
}
object PutProjectEventsResultEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.PutProjectEventsResultEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.PutProjectEventsResultEntry =
      zio.aws.evidently.model.PutProjectEventsResultEntry(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        eventId.map(value => value)
      )
    def errorCode: Option[ErrorCodeEnum]
    def errorMessage: Option[ErrorMessage]
    def eventId: Option[Uuid]
    def getErrorCode: ZIO[Any, AwsError, ErrorCodeEnum] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getEventId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("eventId", eventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.PutProjectEventsResultEntry
  ) extends zio.aws.evidently.model.PutProjectEventsResultEntry.ReadOnly {
    override val errorCode: Option[ErrorCodeEnum] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.evidently.model.primitives.ErrorCodeEnum(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.evidently.model.primitives.ErrorMessage(value))
    override val eventId: Option[Uuid] = scala
      .Option(impl.eventId())
      .map(value => zio.aws.evidently.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.PutProjectEventsResultEntry
  ): zio.aws.evidently.model.PutProjectEventsResultEntry.ReadOnly = new Wrapper(
    impl
  )
}
