package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  Timestamp,
  TagValue,
  ProjectRef,
  LaunchArn,
  RandomizationSalt,
  Description,
  LaunchName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Launch(
    arn: LaunchArn,
    createdTime: Timestamp,
    description: Option[Description] = None,
    execution: Option[zio.aws.evidently.model.LaunchExecution] = None,
    groups: Option[Iterable[zio.aws.evidently.model.LaunchGroup]] = None,
    lastUpdatedTime: Timestamp,
    metricMonitors: Option[Iterable[zio.aws.evidently.model.MetricMonitor]] =
      None,
    name: LaunchName,
    project: Option[ProjectRef] = None,
    randomizationSalt: Option[RandomizationSalt] = None,
    scheduledSplitsDefinition: Option[
      zio.aws.evidently.model.ScheduledSplitsLaunchDefinition
    ] = None,
    status: zio.aws.evidently.model.LaunchStatus,
    statusReason: Option[Description] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    `type`: zio.aws.evidently.model.LaunchType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.Launch = {
    import Launch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.Launch
      .builder()
      .arn(LaunchArn.unwrap(arn): java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(execution.map(value => value.buildAwsValue()))(
        _.execution
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .optionallyWith(
        metricMonitors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricMonitors)
      .name(LaunchName.unwrap(name): java.lang.String)
      .optionallyWith(
        project.map(value => ProjectRef.unwrap(value): java.lang.String)
      )(_.project)
      .optionallyWith(
        randomizationSalt.map(value =>
          RandomizationSalt.unwrap(value): java.lang.String
        )
      )(_.randomizationSalt)
      .optionallyWith(
        scheduledSplitsDefinition.map(value => value.buildAwsValue())
      )(_.scheduledSplitsDefinition)
      .status(status.unwrap)
      .optionallyWith(
        statusReason.map(value => Description.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.Launch.ReadOnly =
    zio.aws.evidently.model.Launch.wrap(buildAwsValue())
}
object Launch {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.evidently.model.Launch] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.Launch =
      zio.aws.evidently.model.Launch(
        arn,
        createdTime,
        description.map(value => value),
        execution.map(value => value.asEditable),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastUpdatedTime,
        metricMonitors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name,
        project.map(value => value),
        randomizationSalt.map(value => value),
        scheduledSplitsDefinition.map(value => value.asEditable),
        status,
        statusReason.map(value => value),
        tags.map(value => value),
        `type`
      )
    def arn: LaunchArn
    def createdTime: Timestamp
    def description: Option[Description]
    def execution: Option[zio.aws.evidently.model.LaunchExecution.ReadOnly]
    def groups: Option[List[zio.aws.evidently.model.LaunchGroup.ReadOnly]]
    def lastUpdatedTime: Timestamp
    def metricMonitors
        : Option[List[zio.aws.evidently.model.MetricMonitor.ReadOnly]]
    def name: LaunchName
    def project: Option[ProjectRef]
    def randomizationSalt: Option[RandomizationSalt]
    def scheduledSplitsDefinition: Option[
      zio.aws.evidently.model.ScheduledSplitsLaunchDefinition.ReadOnly
    ]
    def status: zio.aws.evidently.model.LaunchStatus
    def statusReason: Option[Description]
    def tags: Option[Map[TagKey, TagValue]]
    def `type`: zio.aws.evidently.model.LaunchType
    def getArn: ZIO[Any, Nothing, LaunchArn] = ZIO.succeed(arn)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getExecution
        : ZIO[Any, AwsError, zio.aws.evidently.model.LaunchExecution.ReadOnly] =
      AwsError.unwrapOptionField("execution", execution)
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.LaunchGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
    def getMetricMonitors: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.MetricMonitor.ReadOnly
    ]] = AwsError.unwrapOptionField("metricMonitors", metricMonitors)
    def getName: ZIO[Any, Nothing, LaunchName] = ZIO.succeed(name)
    def getProject: ZIO[Any, AwsError, ProjectRef] =
      AwsError.unwrapOptionField("project", project)
    def getRandomizationSalt: ZIO[Any, AwsError, RandomizationSalt] =
      AwsError.unwrapOptionField("randomizationSalt", randomizationSalt)
    def getScheduledSplitsDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ScheduledSplitsLaunchDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduledSplitsDefinition",
      scheduledSplitsDefinition
    )
    def getStatus: ZIO[Any, Nothing, zio.aws.evidently.model.LaunchStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, Nothing, zio.aws.evidently.model.LaunchType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.Launch
  ) extends zio.aws.evidently.model.Launch.ReadOnly {
    override val arn: LaunchArn =
      zio.aws.evidently.model.primitives.LaunchArn(impl.arn())
    override val createdTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.createdTime())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val execution
        : Option[zio.aws.evidently.model.LaunchExecution.ReadOnly] = scala
      .Option(impl.execution())
      .map(value => zio.aws.evidently.model.LaunchExecution.wrap(value))
    override val groups
        : Option[List[zio.aws.evidently.model.LaunchGroup.ReadOnly]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.LaunchGroup.wrap(item)
        }.toList
      )
    override val lastUpdatedTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.lastUpdatedTime())
    override val metricMonitors
        : Option[List[zio.aws.evidently.model.MetricMonitor.ReadOnly]] = scala
      .Option(impl.metricMonitors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.MetricMonitor.wrap(item)
        }.toList
      )
    override val name: LaunchName =
      zio.aws.evidently.model.primitives.LaunchName(impl.name())
    override val project: Option[ProjectRef] = scala
      .Option(impl.project())
      .map(value => zio.aws.evidently.model.primitives.ProjectRef(value))
    override val randomizationSalt: Option[RandomizationSalt] = scala
      .Option(impl.randomizationSalt())
      .map(value => zio.aws.evidently.model.primitives.RandomizationSalt(value))
    override val scheduledSplitsDefinition: Option[
      zio.aws.evidently.model.ScheduledSplitsLaunchDefinition.ReadOnly
    ] = scala
      .Option(impl.scheduledSplitsDefinition())
      .map(value =>
        zio.aws.evidently.model.ScheduledSplitsLaunchDefinition.wrap(value)
      )
    override val status: zio.aws.evidently.model.LaunchStatus =
      zio.aws.evidently.model.LaunchStatus.wrap(impl.status())
    override val statusReason: Option[Description] = scala
      .Option(impl.statusReason())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: zio.aws.evidently.model.LaunchType =
      zio.aws.evidently.model.LaunchType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.Launch
  ): zio.aws.evidently.model.Launch.ReadOnly = new Wrapper(impl)
}
