package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetFeatureResponse(feature: zio.aws.evidently.model.Feature) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetFeatureResponse = {
    import GetFeatureResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetFeatureResponse
      .builder()
      .feature(feature.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetFeatureResponse.ReadOnly =
    zio.aws.evidently.model.GetFeatureResponse.wrap(buildAwsValue())
}
object GetFeatureResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetFeatureResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetFeatureResponse =
      zio.aws.evidently.model.GetFeatureResponse(feature.asEditable)
    def feature: zio.aws.evidently.model.Feature.ReadOnly
    def getFeature
        : ZIO[Any, Nothing, zio.aws.evidently.model.Feature.ReadOnly] =
      ZIO.succeed(feature)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetFeatureResponse
  ) extends zio.aws.evidently.model.GetFeatureResponse.ReadOnly {
    override val feature: zio.aws.evidently.model.Feature.ReadOnly =
      zio.aws.evidently.model.Feature.wrap(impl.feature())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetFeatureResponse
  ): zio.aws.evidently.model.GetFeatureResponse.ReadOnly = new Wrapper(impl)
}
