package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{ProjectRef, FeatureName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetFeatureRequest(feature: FeatureName, project: ProjectRef) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetFeatureRequest = {
    import GetFeatureRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetFeatureRequest
      .builder()
      .feature(FeatureName.unwrap(feature): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetFeatureRequest.ReadOnly =
    zio.aws.evidently.model.GetFeatureRequest.wrap(buildAwsValue())
}
object GetFeatureRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetFeatureRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetFeatureRequest =
      zio.aws.evidently.model.GetFeatureRequest(feature, project)
    def feature: FeatureName
    def project: ProjectRef
    def getFeature: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(feature)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetFeatureRequest
  ) extends zio.aws.evidently.model.GetFeatureRequest.ReadOnly {
    override val feature: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.feature())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetFeatureRequest
  ): zio.aws.evidently.model.GetFeatureRequest.ReadOnly = new Wrapper(impl)
}
