package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  FeatureArn,
  VariationName,
  Timestamp,
  TagValue,
  ProjectArn,
  Description,
  EntityId,
  FeatureName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Feature(
    arn: FeatureArn,
    createdTime: Timestamp,
    defaultVariation: Option[VariationName] = None,
    description: Option[Description] = None,
    entityOverrides: Option[Map[EntityId, VariationName]] = None,
    evaluationRules: Option[Iterable[zio.aws.evidently.model.EvaluationRule]] =
      None,
    evaluationStrategy: zio.aws.evidently.model.FeatureEvaluationStrategy,
    lastUpdatedTime: Timestamp,
    name: FeatureName,
    project: Option[ProjectArn] = None,
    status: zio.aws.evidently.model.FeatureStatus,
    tags: Option[Map[TagKey, TagValue]] = None,
    valueType: zio.aws.evidently.model.VariationValueType,
    variations: Iterable[zio.aws.evidently.model.Variation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.Feature = {
    import Feature.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.Feature
      .builder()
      .arn(FeatureArn.unwrap(arn): java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .optionallyWith(
        defaultVariation.map(value =>
          VariationName.unwrap(value): java.lang.String
        )
      )(_.defaultVariation)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        entityOverrides.map(value =>
          value
            .map({ case (key, value) =>
              (EntityId.unwrap(key): java.lang.String) -> (VariationName.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.entityOverrides)
      .optionallyWith(
        evaluationRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evaluationRules)
      .evaluationStrategy(evaluationStrategy.unwrap)
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .name(FeatureName.unwrap(name): java.lang.String)
      .optionallyWith(
        project.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.project)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .valueType(valueType.unwrap)
      .variations(variations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.Feature.ReadOnly =
    zio.aws.evidently.model.Feature.wrap(buildAwsValue())
}
object Feature {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.evidently.model.Feature] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.Feature =
      zio.aws.evidently.model.Feature(
        arn,
        createdTime,
        defaultVariation.map(value => value),
        description.map(value => value),
        entityOverrides.map(value => value),
        evaluationRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        evaluationStrategy,
        lastUpdatedTime,
        name,
        project.map(value => value),
        status,
        tags.map(value => value),
        valueType,
        variations.map { item =>
          item.asEditable
        }
      )
    def arn: FeatureArn
    def createdTime: Timestamp
    def defaultVariation: Option[VariationName]
    def description: Option[Description]
    def entityOverrides: Option[Map[EntityId, VariationName]]
    def evaluationRules
        : Option[List[zio.aws.evidently.model.EvaluationRule.ReadOnly]]
    def evaluationStrategy: zio.aws.evidently.model.FeatureEvaluationStrategy
    def lastUpdatedTime: Timestamp
    def name: FeatureName
    def project: Option[ProjectArn]
    def status: zio.aws.evidently.model.FeatureStatus
    def tags: Option[Map[TagKey, TagValue]]
    def valueType: zio.aws.evidently.model.VariationValueType
    def variations: List[zio.aws.evidently.model.Variation.ReadOnly]
    def getArn: ZIO[Any, Nothing, FeatureArn] = ZIO.succeed(arn)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getDefaultVariation: ZIO[Any, AwsError, VariationName] =
      AwsError.unwrapOptionField("defaultVariation", defaultVariation)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEntityOverrides: ZIO[Any, AwsError, Map[EntityId, VariationName]] =
      AwsError.unwrapOptionField("entityOverrides", entityOverrides)
    def getEvaluationRules: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.EvaluationRule.ReadOnly
    ]] = AwsError.unwrapOptionField("evaluationRules", evaluationRules)
    def getEvaluationStrategy
        : ZIO[Any, Nothing, zio.aws.evidently.model.FeatureEvaluationStrategy] =
      ZIO.succeed(evaluationStrategy)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
    def getName: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(name)
    def getProject: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("project", project)
    def getStatus: ZIO[Any, Nothing, zio.aws.evidently.model.FeatureStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getValueType
        : ZIO[Any, Nothing, zio.aws.evidently.model.VariationValueType] =
      ZIO.succeed(valueType)
    def getVariations
        : ZIO[Any, Nothing, List[zio.aws.evidently.model.Variation.ReadOnly]] =
      ZIO.succeed(variations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.Feature
  ) extends zio.aws.evidently.model.Feature.ReadOnly {
    override val arn: FeatureArn =
      zio.aws.evidently.model.primitives.FeatureArn(impl.arn())
    override val createdTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.createdTime())
    override val defaultVariation: Option[VariationName] = scala
      .Option(impl.defaultVariation())
      .map(value => zio.aws.evidently.model.primitives.VariationName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val entityOverrides: Option[Map[EntityId, VariationName]] = scala
      .Option(impl.entityOverrides())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives.EntityId(
              key
            ) -> zio.aws.evidently.model.primitives.VariationName(value)
          })
          .toMap
      )
    override val evaluationRules
        : Option[List[zio.aws.evidently.model.EvaluationRule.ReadOnly]] = scala
      .Option(impl.evaluationRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.EvaluationRule.wrap(item)
        }.toList
      )
    override val evaluationStrategy
        : zio.aws.evidently.model.FeatureEvaluationStrategy =
      zio.aws.evidently.model.FeatureEvaluationStrategy
        .wrap(impl.evaluationStrategy())
    override val lastUpdatedTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.lastUpdatedTime())
    override val name: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.name())
    override val project: Option[ProjectArn] = scala
      .Option(impl.project())
      .map(value => zio.aws.evidently.model.primitives.ProjectArn(value))
    override val status: zio.aws.evidently.model.FeatureStatus =
      zio.aws.evidently.model.FeatureStatus.wrap(impl.status())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val valueType: zio.aws.evidently.model.VariationValueType =
      zio.aws.evidently.model.VariationValueType.wrap(impl.valueType())
    override val variations: List[zio.aws.evidently.model.Variation.ReadOnly] =
      impl
        .variations()
        .asScala
        .map { item =>
          zio.aws.evidently.model.Variation.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.Feature
  ): zio.aws.evidently.model.Feature.ReadOnly = new Wrapper(impl)
}
