package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.CwLogGroupSafeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CloudWatchLogsDestinationConfig(
    logGroup: Option[CwLogGroupSafeName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestinationConfig = {
    import CloudWatchLogsDestinationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestinationConfig
      .builder()
      .optionallyWith(
        logGroup.map(value =>
          CwLogGroupSafeName.unwrap(value): java.lang.String
        )
      )(_.logGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.evidently.model.CloudWatchLogsDestinationConfig.ReadOnly =
    zio.aws.evidently.model.CloudWatchLogsDestinationConfig
      .wrap(buildAwsValue())
}
object CloudWatchLogsDestinationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestinationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CloudWatchLogsDestinationConfig =
      zio.aws.evidently.model
        .CloudWatchLogsDestinationConfig(logGroup.map(value => value))
    def logGroup: Option[CwLogGroupSafeName]
    def getLogGroup: ZIO[Any, AwsError, CwLogGroupSafeName] =
      AwsError.unwrapOptionField("logGroup", logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestinationConfig
  ) extends zio.aws.evidently.model.CloudWatchLogsDestinationConfig.ReadOnly {
    override val logGroup: Option[CwLogGroupSafeName] = scala
      .Option(impl.logGroup())
      .map(value =>
        zio.aws.evidently.model.primitives.CwLogGroupSafeName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestinationConfig
  ): zio.aws.evidently.model.CloudWatchLogsDestinationConfig.ReadOnly =
    new Wrapper(impl)
}
