package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.CwLogGroupSafeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CloudWatchLogsDestination(
    logGroup: Option[CwLogGroupSafeName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination = {
    import CloudWatchLogsDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination
      .builder()
      .optionallyWith(
        logGroup.map(value =>
          CwLogGroupSafeName.unwrap(value): java.lang.String
        )
      )(_.logGroup)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly =
    zio.aws.evidently.model.CloudWatchLogsDestination.wrap(buildAwsValue())
}
object CloudWatchLogsDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CloudWatchLogsDestination =
      zio.aws.evidently.model
        .CloudWatchLogsDestination(logGroup.map(value => value))
    def logGroup: Option[CwLogGroupSafeName]
    def getLogGroup: ZIO[Any, AwsError, CwLogGroupSafeName] =
      AwsError.unwrapOptionField("logGroup", logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination
  ) extends zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly {
    override val logGroup: Option[CwLogGroupSafeName] = scala
      .Option(impl.logGroup())
      .map(value =>
        zio.aws.evidently.model.primitives.CwLogGroupSafeName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestination
  ): zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly = new Wrapper(
    impl
  )
}
