package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  RandomizationSalt,
  ProjectRef,
  LaunchName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateLaunchRequest(
    description: Option[Description] = None,
    groups: Option[Iterable[zio.aws.evidently.model.LaunchGroupConfig]] = None,
    launch: LaunchName,
    metricMonitors: Option[
      Iterable[zio.aws.evidently.model.MetricMonitorConfig]
    ] = None,
    project: ProjectRef,
    randomizationSalt: Option[RandomizationSalt] = None,
    scheduledSplitsConfig: Option[
      zio.aws.evidently.model.ScheduledSplitsLaunchConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UpdateLaunchRequest = {
    import UpdateLaunchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UpdateLaunchRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .launch(LaunchName.unwrap(launch): java.lang.String)
      .optionallyWith(
        metricMonitors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricMonitors)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        randomizationSalt.map(value =>
          RandomizationSalt.unwrap(value): java.lang.String
        )
      )(_.randomizationSalt)
      .optionallyWith(
        scheduledSplitsConfig.map(value => value.buildAwsValue())
      )(_.scheduledSplitsConfig)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.UpdateLaunchRequest.ReadOnly =
    zio.aws.evidently.model.UpdateLaunchRequest.wrap(buildAwsValue())
}
object UpdateLaunchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UpdateLaunchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UpdateLaunchRequest =
      zio.aws.evidently.model.UpdateLaunchRequest(
        description.map(value => value),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launch,
        metricMonitors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        project,
        randomizationSalt.map(value => value),
        scheduledSplitsConfig.map(value => value.asEditable)
      )
    def description: Option[Description]
    def groups: Option[List[zio.aws.evidently.model.LaunchGroupConfig.ReadOnly]]
    def launch: LaunchName
    def metricMonitors
        : Option[List[zio.aws.evidently.model.MetricMonitorConfig.ReadOnly]]
    def project: ProjectRef
    def randomizationSalt: Option[RandomizationSalt]
    def scheduledSplitsConfig
        : Option[zio.aws.evidently.model.ScheduledSplitsLaunchConfig.ReadOnly]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.LaunchGroupConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
    def getLaunch: ZIO[Any, Nothing, LaunchName] = ZIO.succeed(launch)
    def getMetricMonitors: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.MetricMonitorConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("metricMonitors", metricMonitors)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getRandomizationSalt: ZIO[Any, AwsError, RandomizationSalt] =
      AwsError.unwrapOptionField("randomizationSalt", randomizationSalt)
    def getScheduledSplitsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ScheduledSplitsLaunchConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("scheduledSplitsConfig", scheduledSplitsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UpdateLaunchRequest
  ) extends zio.aws.evidently.model.UpdateLaunchRequest.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val groups
        : Option[List[zio.aws.evidently.model.LaunchGroupConfig.ReadOnly]] =
      scala
        .Option(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.LaunchGroupConfig.wrap(item)
          }.toList
        )
    override val launch: LaunchName =
      zio.aws.evidently.model.primitives.LaunchName(impl.launch())
    override val metricMonitors
        : Option[List[zio.aws.evidently.model.MetricMonitorConfig.ReadOnly]] =
      scala
        .Option(impl.metricMonitors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.MetricMonitorConfig.wrap(item)
          }.toList
        )
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val randomizationSalt: Option[RandomizationSalt] = scala
      .Option(impl.randomizationSalt())
      .map(value => zio.aws.evidently.model.primitives.RandomizationSalt(value))
    override val scheduledSplitsConfig
        : Option[zio.aws.evidently.model.ScheduledSplitsLaunchConfig.ReadOnly] =
      scala
        .Option(impl.scheduledSplitsConfig())
        .map(value =>
          zio.aws.evidently.model.ScheduledSplitsLaunchConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UpdateLaunchRequest
  ): zio.aws.evidently.model.UpdateLaunchRequest.ReadOnly = new Wrapper(impl)
}
