package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  VariationName,
  TreatmentName,
  FeatureName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TreatmentConfig(
    description: Option[Description] = None,
    feature: FeatureName,
    name: TreatmentName,
    variation: VariationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.TreatmentConfig = {
    import TreatmentConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.TreatmentConfig
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .feature(FeatureName.unwrap(feature): java.lang.String)
      .name(TreatmentName.unwrap(name): java.lang.String)
      .variation(VariationName.unwrap(variation): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.TreatmentConfig.ReadOnly =
    zio.aws.evidently.model.TreatmentConfig.wrap(buildAwsValue())
}
object TreatmentConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.TreatmentConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.TreatmentConfig =
      zio.aws.evidently.model.TreatmentConfig(
        description.map(value => value),
        feature,
        name,
        variation
      )
    def description: Option[Description]
    def feature: FeatureName
    def name: TreatmentName
    def variation: VariationName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFeature: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(feature)
    def getName: ZIO[Any, Nothing, TreatmentName] = ZIO.succeed(name)
    def getVariation: ZIO[Any, Nothing, VariationName] = ZIO.succeed(variation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.TreatmentConfig
  ) extends zio.aws.evidently.model.TreatmentConfig.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val feature: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.feature())
    override val name: TreatmentName =
      zio.aws.evidently.model.primitives.TreatmentName(impl.name())
    override val variation: VariationName =
      zio.aws.evidently.model.primitives.VariationName(impl.variation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.TreatmentConfig
  ): zio.aws.evidently.model.TreatmentConfig.ReadOnly = new Wrapper(impl)
}
