package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StartExperimentResponse(
    startedTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.StartExperimentResponse = {
    import StartExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.StartExperimentResponse
      .builder()
      .optionallyWith(
        startedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.startedTime)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.StartExperimentResponse.ReadOnly =
    zio.aws.evidently.model.StartExperimentResponse.wrap(buildAwsValue())
}
object StartExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.StartExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.StartExperimentResponse =
      zio.aws.evidently.model
        .StartExperimentResponse(startedTime.map(value => value))
    def startedTime: Option[Timestamp]
    def getStartedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedTime", startedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.StartExperimentResponse
  ) extends zio.aws.evidently.model.StartExperimentResponse.ReadOnly {
    override val startedTime: Option[Timestamp] = scala
      .Option(impl.startedTime())
      .map(value => zio.aws.evidently.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.StartExperimentResponse
  ): zio.aws.evidently.model.StartExperimentResponse.ReadOnly = new Wrapper(
    impl
  )
}
