package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ScheduledSplitsLaunchDefinition(
    steps: Option[Iterable[zio.aws.evidently.model.ScheduledSplit]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchDefinition = {
    import ScheduledSplitsLaunchDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchDefinition
      .builder()
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .build()
  }
  def asReadOnly
      : zio.aws.evidently.model.ScheduledSplitsLaunchDefinition.ReadOnly =
    zio.aws.evidently.model.ScheduledSplitsLaunchDefinition
      .wrap(buildAwsValue())
}
object ScheduledSplitsLaunchDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ScheduledSplitsLaunchDefinition =
      zio.aws.evidently.model.ScheduledSplitsLaunchDefinition(
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def steps: Option[List[zio.aws.evidently.model.ScheduledSplit.ReadOnly]]
    def getSteps: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.ScheduledSplit.ReadOnly
    ]] = AwsError.unwrapOptionField("steps", steps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchDefinition
  ) extends zio.aws.evidently.model.ScheduledSplitsLaunchDefinition.ReadOnly {
    override val steps
        : Option[List[zio.aws.evidently.model.ScheduledSplit.ReadOnly]] = scala
      .Option(impl.steps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.ScheduledSplit.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchDefinition
  ): zio.aws.evidently.model.ScheduledSplitsLaunchDefinition.ReadOnly =
    new Wrapper(impl)
}
