package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class LaunchExecution(
    endedTime: Option[Timestamp] = None,
    startedTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.LaunchExecution = {
    import LaunchExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.LaunchExecution
      .builder()
      .optionallyWith(endedTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endedTime
      )
      .optionallyWith(
        startedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.startedTime)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.LaunchExecution.ReadOnly =
    zio.aws.evidently.model.LaunchExecution.wrap(buildAwsValue())
}
object LaunchExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.LaunchExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.LaunchExecution =
      zio.aws.evidently.model.LaunchExecution(
        endedTime.map(value => value),
        startedTime.map(value => value)
      )
    def endedTime: Option[Timestamp]
    def startedTime: Option[Timestamp]
    def getEndedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endedTime", endedTime)
    def getStartedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedTime", startedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.LaunchExecution
  ) extends zio.aws.evidently.model.LaunchExecution.ReadOnly {
    override val endedTime: Option[Timestamp] = scala
      .Option(impl.endedTime())
      .map(value => zio.aws.evidently.model.primitives.Timestamp(value))
    override val startedTime: Option[Timestamp] = scala
      .Option(impl.startedTime())
      .map(value => zio.aws.evidently.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.LaunchExecution
  ): zio.aws.evidently.model.LaunchExecution.ReadOnly = new Wrapper(impl)
}
