package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.JsonValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EvaluateFeatureResponse(
    details: Option[JsonValue] = None,
    reason: Option[String] = None,
    value: Option[zio.aws.evidently.model.VariableValue] = None,
    variation: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.EvaluateFeatureResponse = {
    import EvaluateFeatureResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.EvaluateFeatureResponse
      .builder()
      .optionallyWith(
        details.map(value => JsonValue.unwrap(value): java.lang.String)
      )(_.details)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(variation.map(value => value: java.lang.String))(
        _.variation
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.EvaluateFeatureResponse.ReadOnly =
    zio.aws.evidently.model.EvaluateFeatureResponse.wrap(buildAwsValue())
}
object EvaluateFeatureResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.EvaluateFeatureResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.EvaluateFeatureResponse =
      zio.aws.evidently.model.EvaluateFeatureResponse(
        details.map(value => value),
        reason.map(value => value),
        value.map(value => value.asEditable),
        variation.map(value => value)
      )
    def details: Option[JsonValue]
    def reason: Option[String]
    def value: Option[zio.aws.evidently.model.VariableValue.ReadOnly]
    def variation: Option[String]
    def getDetails: ZIO[Any, AwsError, JsonValue] =
      AwsError.unwrapOptionField("details", details)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getValue
        : ZIO[Any, AwsError, zio.aws.evidently.model.VariableValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
    def getVariation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("variation", variation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.EvaluateFeatureResponse
  ) extends zio.aws.evidently.model.EvaluateFeatureResponse.ReadOnly {
    override val details: Option[JsonValue] = scala
      .Option(impl.details())
      .map(value => zio.aws.evidently.model.primitives.JsonValue(value))
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
    override val value: Option[zio.aws.evidently.model.VariableValue.ReadOnly] =
      scala
        .Option(impl.value())
        .map(value => zio.aws.evidently.model.VariableValue.wrap(value))
    override val variation: Option[String] =
      scala.Option(impl.variation()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.EvaluateFeatureResponse
  ): zio.aws.evidently.model.EvaluateFeatureResponse.ReadOnly = new Wrapper(
    impl
  )
}
