package zio.aws.evidently
import zio.aws.evidently.model.ListFeaturesResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.evidently.{
  EvidentlyAsyncClientBuilder,
  EvidentlyAsyncClient
}
import software.amazon.awssdk.services.evidently.paginators.{
  ListLaunchesPublisher,
  ListExperimentsPublisher,
  ListFeaturesPublisher,
  ListProjectsPublisher
}
import zio.aws.evidently.model.{
  EvaluateFeatureRequest,
  GetExperimentResultsRequest,
  GetProjectRequest,
  CreateProjectRequest,
  DeleteFeatureRequest,
  StopLaunchRequest,
  StartExperimentRequest,
  StopExperimentRequest,
  ListLaunchesRequest,
  StartLaunchRequest,
  CreateFeatureRequest,
  UpdateExperimentRequest,
  ListTagsForResourceRequest,
  CreateLaunchRequest,
  GetExperimentRequest,
  UpdateProjectRequest,
  DeleteProjectRequest,
  PutProjectEventsRequest,
  GetLaunchRequest,
  CreateExperimentRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  UpdateLaunchRequest,
  DeleteExperimentRequest,
  BatchEvaluateFeatureRequest,
  DeleteLaunchRequest,
  GetFeatureRequest,
  ListExperimentsRequest,
  ListFeaturesRequest,
  UpdateProjectDataDeliveryRequest,
  UpdateFeatureRequest,
  TagResourceRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.evidently.model.{
  GetExperimentResponse,
  UpdateExperimentResponse,
  GetExperimentResultsResponse,
  ListProjectsResponse,
  UpdateLaunchResponse,
  GetLaunchResponse,
  ListLaunchesResponse,
  CreateLaunchResponse,
  DeleteFeatureResponse,
  Launch,
  GetFeatureResponse,
  StartExperimentResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  BatchEvaluateFeatureResponse,
  CreateProjectResponse,
  FeatureSummary,
  DeleteLaunchResponse,
  StopExperimentResponse,
  EvaluateFeatureResponse,
  StopLaunchResponse,
  ProjectSummary,
  DeleteExperimentResponse,
  CreateFeatureResponse,
  PutProjectEventsResponse,
  UpdateProjectResponse,
  Experiment,
  TagResourceResponse,
  UpdateFeatureResponse,
  UpdateProjectDataDeliveryResponse,
  DeleteProjectResponse,
  ListFeaturesResponse,
  ListExperimentsResponse,
  StartLaunchResponse,
  GetProjectResponse,
  CreateExperimentResponse
}
import scala.jdk.CollectionConverters.*
trait Evidently extends AspectSupport[Evidently] {
  val api: EvidentlyAsyncClient
  def deleteLaunch(
      request: DeleteLaunchRequest
  ): IO[AwsError, zio.aws.evidently.model.DeleteLaunchResponse.ReadOnly]
  def getProject(
      request: GetProjectRequest
  ): IO[AwsError, zio.aws.evidently.model.GetProjectResponse.ReadOnly]
  def putProjectEvents(
      request: PutProjectEventsRequest
  ): IO[AwsError, zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly]
  def getLaunch(
      request: GetLaunchRequest
  ): IO[AwsError, zio.aws.evidently.model.GetLaunchResponse.ReadOnly]
  def batchEvaluateFeature(
      request: BatchEvaluateFeatureRequest
  ): IO[AwsError, zio.aws.evidently.model.BatchEvaluateFeatureResponse.ReadOnly]
  def createLaunch(
      request: CreateLaunchRequest
  ): IO[AwsError, zio.aws.evidently.model.CreateLaunchResponse.ReadOnly]
  def getExperimentResults(
      request: GetExperimentResultsRequest
  ): IO[AwsError, zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly]
  def stopLaunch(
      request: StopLaunchRequest
  ): IO[AwsError, zio.aws.evidently.model.StopLaunchResponse.ReadOnly]
  def updateProject(
      request: UpdateProjectRequest
  ): IO[AwsError, zio.aws.evidently.model.UpdateProjectResponse.ReadOnly]
  def createFeature(
      request: CreateFeatureRequest
  ): IO[AwsError, zio.aws.evidently.model.CreateFeatureResponse.ReadOnly]
  def deleteFeature(
      request: DeleteFeatureRequest
  ): IO[AwsError, zio.aws.evidently.model.DeleteFeatureResponse.ReadOnly]
  def createExperiment(
      request: CreateExperimentRequest
  ): IO[AwsError, zio.aws.evidently.model.CreateExperimentResponse.ReadOnly]
  def listProjects(
      request: ListProjectsRequest
  ): ZStream[Any, AwsError, zio.aws.evidently.model.ProjectSummary.ReadOnly]
  def listProjectsPaginated(
      request: ListProjectsRequest
  ): IO[AwsError, zio.aws.evidently.model.ListProjectsResponse.ReadOnly]
  def updateLaunch(
      request: UpdateLaunchRequest
  ): IO[AwsError, zio.aws.evidently.model.UpdateLaunchResponse.ReadOnly]
  def startExperiment(
      request: StartExperimentRequest
  ): IO[AwsError, zio.aws.evidently.model.StartExperimentResponse.ReadOnly]
  def deleteExperiment(
      request: DeleteExperimentRequest
  ): IO[AwsError, zio.aws.evidently.model.DeleteExperimentResponse.ReadOnly]
  def getFeature(
      request: GetFeatureRequest
  ): IO[AwsError, zio.aws.evidently.model.GetFeatureResponse.ReadOnly]
  def updateProjectDataDelivery(request: UpdateProjectDataDeliveryRequest): IO[
    AwsError,
    zio.aws.evidently.model.UpdateProjectDataDeliveryResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.evidently.model.UntagResourceResponse.ReadOnly]
  def createProject(
      request: CreateProjectRequest
  ): IO[AwsError, zio.aws.evidently.model.CreateProjectResponse.ReadOnly]
  def startLaunch(
      request: StartLaunchRequest
  ): IO[AwsError, zio.aws.evidently.model.StartLaunchResponse.ReadOnly]
  def listFeatures(
      request: ListFeaturesRequest
  ): ZStream[Any, AwsError, zio.aws.evidently.model.FeatureSummary.ReadOnly]
  def listFeaturesPaginated(
      request: ListFeaturesRequest
  ): IO[AwsError, ReadOnly]
  def evaluateFeature(
      request: EvaluateFeatureRequest
  ): IO[AwsError, zio.aws.evidently.model.EvaluateFeatureResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.evidently.model.ListTagsForResourceResponse.ReadOnly]
  def updateExperiment(
      request: UpdateExperimentRequest
  ): IO[AwsError, zio.aws.evidently.model.UpdateExperimentResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.evidently.model.TagResourceResponse.ReadOnly]
  def listExperiments(
      request: ListExperimentsRequest
  ): ZStream[Any, AwsError, zio.aws.evidently.model.Experiment.ReadOnly]
  def listExperimentsPaginated(
      request: ListExperimentsRequest
  ): IO[AwsError, zio.aws.evidently.model.ListExperimentsResponse.ReadOnly]
  def stopExperiment(
      request: StopExperimentRequest
  ): IO[AwsError, zio.aws.evidently.model.StopExperimentResponse.ReadOnly]
  def deleteProject(
      request: DeleteProjectRequest
  ): IO[AwsError, zio.aws.evidently.model.DeleteProjectResponse.ReadOnly]
  def updateFeature(
      request: UpdateFeatureRequest
  ): IO[AwsError, zio.aws.evidently.model.UpdateFeatureResponse.ReadOnly]
  def getExperiment(
      request: GetExperimentRequest
  ): IO[AwsError, zio.aws.evidently.model.GetExperimentResponse.ReadOnly]
  def listLaunches(
      request: ListLaunchesRequest
  ): ZStream[Any, AwsError, zio.aws.evidently.model.Launch.ReadOnly]
  def listLaunchesPaginated(
      request: ListLaunchesRequest
  ): IO[AwsError, zio.aws.evidently.model.ListLaunchesResponse.ReadOnly]
}
object Evidently {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Evidently] = customized(
    identity
  )
  def customized(
      customization: EvidentlyAsyncClientBuilder => EvidentlyAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Evidently] = managed(
    customization
  ).toLayer
  def managed(
      customization: EvidentlyAsyncClientBuilder => EvidentlyAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Evidently] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = EvidentlyAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[EvidentlyAsyncClient, EvidentlyAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[EvidentlyAsyncClient, EvidentlyAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new EvidentlyImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class EvidentlyImpl[R](
      override val api: EvidentlyAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Evidently
      with AwsServiceBase[R] {
    override val serviceName: String = "Evidently"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): EvidentlyImpl[R1] = new EvidentlyImpl(api, newAspect, r)
    def deleteLaunch(
        request: DeleteLaunchRequest
    ): IO[AwsError, zio.aws.evidently.model.DeleteLaunchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.DeleteLaunchRequest,
        DeleteLaunchResponse
      ]("deleteLaunch", api.deleteLaunch)(request.buildAwsValue())
        .map(zio.aws.evidently.model.DeleteLaunchResponse.wrap)
        .provideEnvironment(r)
    def getProject(
        request: GetProjectRequest
    ): IO[AwsError, zio.aws.evidently.model.GetProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.GetProjectRequest,
        GetProjectResponse
      ]("getProject", api.getProject)(request.buildAwsValue())
        .map(zio.aws.evidently.model.GetProjectResponse.wrap)
        .provideEnvironment(r)
    def putProjectEvents(
        request: PutProjectEventsRequest
    ): IO[AwsError, zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.PutProjectEventsRequest,
        PutProjectEventsResponse
      ]("putProjectEvents", api.putProjectEvents)(request.buildAwsValue())
        .map(zio.aws.evidently.model.PutProjectEventsResponse.wrap)
        .provideEnvironment(r)
    def getLaunch(
        request: GetLaunchRequest
    ): IO[AwsError, zio.aws.evidently.model.GetLaunchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.GetLaunchRequest,
        GetLaunchResponse
      ]("getLaunch", api.getLaunch)(request.buildAwsValue())
        .map(zio.aws.evidently.model.GetLaunchResponse.wrap)
        .provideEnvironment(r)
    def batchEvaluateFeature(request: BatchEvaluateFeatureRequest): IO[
      AwsError,
      zio.aws.evidently.model.BatchEvaluateFeatureResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureRequest,
      BatchEvaluateFeatureResponse
    ]("batchEvaluateFeature", api.batchEvaluateFeature)(request.buildAwsValue())
      .map(zio.aws.evidently.model.BatchEvaluateFeatureResponse.wrap)
      .provideEnvironment(r)
    def createLaunch(
        request: CreateLaunchRequest
    ): IO[AwsError, zio.aws.evidently.model.CreateLaunchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.CreateLaunchRequest,
        CreateLaunchResponse
      ]("createLaunch", api.createLaunch)(request.buildAwsValue())
        .map(zio.aws.evidently.model.CreateLaunchResponse.wrap)
        .provideEnvironment(r)
    def getExperimentResults(request: GetExperimentResultsRequest): IO[
      AwsError,
      zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.evidently.model.GetExperimentResultsRequest,
      GetExperimentResultsResponse
    ]("getExperimentResults", api.getExperimentResults)(request.buildAwsValue())
      .map(zio.aws.evidently.model.GetExperimentResultsResponse.wrap)
      .provideEnvironment(r)
    def stopLaunch(
        request: StopLaunchRequest
    ): IO[AwsError, zio.aws.evidently.model.StopLaunchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.StopLaunchRequest,
        StopLaunchResponse
      ]("stopLaunch", api.stopLaunch)(request.buildAwsValue())
        .map(zio.aws.evidently.model.StopLaunchResponse.wrap)
        .provideEnvironment(r)
    def updateProject(
        request: UpdateProjectRequest
    ): IO[AwsError, zio.aws.evidently.model.UpdateProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.UpdateProjectRequest,
        UpdateProjectResponse
      ]("updateProject", api.updateProject)(request.buildAwsValue())
        .map(zio.aws.evidently.model.UpdateProjectResponse.wrap)
        .provideEnvironment(r)
    def createFeature(
        request: CreateFeatureRequest
    ): IO[AwsError, zio.aws.evidently.model.CreateFeatureResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.CreateFeatureRequest,
        CreateFeatureResponse
      ]("createFeature", api.createFeature)(request.buildAwsValue())
        .map(zio.aws.evidently.model.CreateFeatureResponse.wrap)
        .provideEnvironment(r)
    def deleteFeature(
        request: DeleteFeatureRequest
    ): IO[AwsError, zio.aws.evidently.model.DeleteFeatureResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.DeleteFeatureRequest,
        DeleteFeatureResponse
      ]("deleteFeature", api.deleteFeature)(request.buildAwsValue())
        .map(zio.aws.evidently.model.DeleteFeatureResponse.wrap)
        .provideEnvironment(r)
    def createExperiment(
        request: CreateExperimentRequest
    ): IO[AwsError, zio.aws.evidently.model.CreateExperimentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.CreateExperimentRequest,
        CreateExperimentResponse
      ]("createExperiment", api.createExperiment)(request.buildAwsValue())
        .map(zio.aws.evidently.model.CreateExperimentResponse.wrap)
        .provideEnvironment(r)
    def listProjects(
        request: ListProjectsRequest
    ): ZStream[Any, AwsError, zio.aws.evidently.model.ProjectSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.evidently.model.ListProjectsRequest,
        ProjectSummary,
        ListProjectsPublisher
      ]("listProjects", api.listProjectsPaginator, _.projects())(
        request.buildAwsValue()
      ).map(item => zio.aws.evidently.model.ProjectSummary.wrap(item))
        .provideEnvironment(r)
    def listProjectsPaginated(
        request: ListProjectsRequest
    ): IO[AwsError, zio.aws.evidently.model.ListProjectsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.ListProjectsRequest,
        ListProjectsResponse
      ]("listProjects", api.listProjects)(request.buildAwsValue())
        .map(zio.aws.evidently.model.ListProjectsResponse.wrap)
        .provideEnvironment(r)
    def updateLaunch(
        request: UpdateLaunchRequest
    ): IO[AwsError, zio.aws.evidently.model.UpdateLaunchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.UpdateLaunchRequest,
        UpdateLaunchResponse
      ]("updateLaunch", api.updateLaunch)(request.buildAwsValue())
        .map(zio.aws.evidently.model.UpdateLaunchResponse.wrap)
        .provideEnvironment(r)
    def startExperiment(
        request: StartExperimentRequest
    ): IO[AwsError, zio.aws.evidently.model.StartExperimentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.StartExperimentRequest,
        StartExperimentResponse
      ]("startExperiment", api.startExperiment)(request.buildAwsValue())
        .map(zio.aws.evidently.model.StartExperimentResponse.wrap)
        .provideEnvironment(r)
    def deleteExperiment(
        request: DeleteExperimentRequest
    ): IO[AwsError, zio.aws.evidently.model.DeleteExperimentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.DeleteExperimentRequest,
        DeleteExperimentResponse
      ]("deleteExperiment", api.deleteExperiment)(request.buildAwsValue())
        .map(zio.aws.evidently.model.DeleteExperimentResponse.wrap)
        .provideEnvironment(r)
    def getFeature(
        request: GetFeatureRequest
    ): IO[AwsError, zio.aws.evidently.model.GetFeatureResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.GetFeatureRequest,
        GetFeatureResponse
      ]("getFeature", api.getFeature)(request.buildAwsValue())
        .map(zio.aws.evidently.model.GetFeatureResponse.wrap)
        .provideEnvironment(r)
    def updateProjectDataDelivery(
        request: UpdateProjectDataDeliveryRequest
    ): IO[
      AwsError,
      zio.aws.evidently.model.UpdateProjectDataDeliveryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryRequest,
      UpdateProjectDataDeliveryResponse
    ]("updateProjectDataDelivery", api.updateProjectDataDelivery)(
      request.buildAwsValue()
    ).map(zio.aws.evidently.model.UpdateProjectDataDeliveryResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.evidently.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.evidently.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createProject(
        request: CreateProjectRequest
    ): IO[AwsError, zio.aws.evidently.model.CreateProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.CreateProjectRequest,
        CreateProjectResponse
      ]("createProject", api.createProject)(request.buildAwsValue())
        .map(zio.aws.evidently.model.CreateProjectResponse.wrap)
        .provideEnvironment(r)
    def startLaunch(
        request: StartLaunchRequest
    ): IO[AwsError, zio.aws.evidently.model.StartLaunchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.StartLaunchRequest,
        StartLaunchResponse
      ]("startLaunch", api.startLaunch)(request.buildAwsValue())
        .map(zio.aws.evidently.model.StartLaunchResponse.wrap)
        .provideEnvironment(r)
    def listFeatures(
        request: ListFeaturesRequest
    ): ZStream[Any, AwsError, zio.aws.evidently.model.FeatureSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.evidently.model.ListFeaturesRequest,
        FeatureSummary,
        ListFeaturesPublisher
      ]("listFeatures", api.listFeaturesPaginator, _.features())(
        request.buildAwsValue()
      ).map(item => zio.aws.evidently.model.FeatureSummary.wrap(item))
        .provideEnvironment(r)
    def listFeaturesPaginated(
        request: ListFeaturesRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.evidently.model.ListFeaturesRequest,
      ListFeaturesResponse
    ]("listFeatures", api.listFeatures)(request.buildAwsValue())
      .map(zio.aws.evidently.model.ListFeaturesResponse.wrap)
      .provideEnvironment(r)
    def evaluateFeature(
        request: EvaluateFeatureRequest
    ): IO[AwsError, zio.aws.evidently.model.EvaluateFeatureResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.EvaluateFeatureRequest,
        EvaluateFeatureResponse
      ]("evaluateFeature", api.evaluateFeature)(request.buildAwsValue())
        .map(zio.aws.evidently.model.EvaluateFeatureResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.evidently.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.evidently.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.evidently.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def updateExperiment(
        request: UpdateExperimentRequest
    ): IO[AwsError, zio.aws.evidently.model.UpdateExperimentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.UpdateExperimentRequest,
        UpdateExperimentResponse
      ]("updateExperiment", api.updateExperiment)(request.buildAwsValue())
        .map(zio.aws.evidently.model.UpdateExperimentResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.evidently.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.evidently.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listExperiments(
        request: ListExperimentsRequest
    ): ZStream[Any, AwsError, zio.aws.evidently.model.Experiment.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.evidently.model.ListExperimentsRequest,
        Experiment,
        ListExperimentsPublisher
      ]("listExperiments", api.listExperimentsPaginator, _.experiments())(
        request.buildAwsValue()
      ).map(item => zio.aws.evidently.model.Experiment.wrap(item))
        .provideEnvironment(r)
    def listExperimentsPaginated(
        request: ListExperimentsRequest
    ): IO[AwsError, zio.aws.evidently.model.ListExperimentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.ListExperimentsRequest,
        ListExperimentsResponse
      ]("listExperiments", api.listExperiments)(request.buildAwsValue())
        .map(zio.aws.evidently.model.ListExperimentsResponse.wrap)
        .provideEnvironment(r)
    def stopExperiment(
        request: StopExperimentRequest
    ): IO[AwsError, zio.aws.evidently.model.StopExperimentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.StopExperimentRequest,
        StopExperimentResponse
      ]("stopExperiment", api.stopExperiment)(request.buildAwsValue())
        .map(zio.aws.evidently.model.StopExperimentResponse.wrap)
        .provideEnvironment(r)
    def deleteProject(
        request: DeleteProjectRequest
    ): IO[AwsError, zio.aws.evidently.model.DeleteProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.DeleteProjectRequest,
        DeleteProjectResponse
      ]("deleteProject", api.deleteProject)(request.buildAwsValue())
        .map(zio.aws.evidently.model.DeleteProjectResponse.wrap)
        .provideEnvironment(r)
    def updateFeature(
        request: UpdateFeatureRequest
    ): IO[AwsError, zio.aws.evidently.model.UpdateFeatureResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest,
        UpdateFeatureResponse
      ]("updateFeature", api.updateFeature)(request.buildAwsValue())
        .map(zio.aws.evidently.model.UpdateFeatureResponse.wrap)
        .provideEnvironment(r)
    def getExperiment(
        request: GetExperimentRequest
    ): IO[AwsError, zio.aws.evidently.model.GetExperimentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.GetExperimentRequest,
        GetExperimentResponse
      ]("getExperiment", api.getExperiment)(request.buildAwsValue())
        .map(zio.aws.evidently.model.GetExperimentResponse.wrap)
        .provideEnvironment(r)
    def listLaunches(
        request: ListLaunchesRequest
    ): ZStream[Any, AwsError, zio.aws.evidently.model.Launch.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.evidently.model.ListLaunchesRequest,
        Launch,
        ListLaunchesPublisher
      ]("listLaunches", api.listLaunchesPaginator, _.launches())(
        request.buildAwsValue()
      ).map(item => zio.aws.evidently.model.Launch.wrap(item))
        .provideEnvironment(r)
    def listLaunchesPaginated(
        request: ListLaunchesRequest
    ): IO[AwsError, zio.aws.evidently.model.ListLaunchesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.evidently.model.ListLaunchesRequest,
        ListLaunchesResponse
      ]("listLaunches", api.listLaunches)(request.buildAwsValue())
        .map(zio.aws.evidently.model.ListLaunchesResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteLaunch(request: DeleteLaunchRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.DeleteLaunchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLaunch(request))
  def getProject(request: GetProjectRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.GetProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProject(request))
  def putProjectEvents(request: PutProjectEventsRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putProjectEvents(request))
  def getLaunch(request: GetLaunchRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.GetLaunchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLaunch(request))
  def batchEvaluateFeature(request: BatchEvaluateFeatureRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.BatchEvaluateFeatureResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchEvaluateFeature(request))
  def createLaunch(request: CreateLaunchRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.CreateLaunchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLaunch(request))
  def getExperimentResults(request: GetExperimentResultsRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getExperimentResults(request))
  def stopLaunch(request: StopLaunchRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.StopLaunchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopLaunch(request))
  def updateProject(request: UpdateProjectRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.UpdateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProject(request))
  def createFeature(request: CreateFeatureRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.CreateFeatureResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFeature(request))
  def deleteFeature(request: DeleteFeatureRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.DeleteFeatureResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFeature(request))
  def createExperiment(request: CreateExperimentRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.CreateExperimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createExperiment(request))
  def listProjects(request: ListProjectsRequest): ZStream[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.ProjectSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjects(request))
  def listProjectsPaginated(request: ListProjectsRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.ListProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectsPaginated(request))
  def updateLaunch(request: UpdateLaunchRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.UpdateLaunchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLaunch(request))
  def startExperiment(request: StartExperimentRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.StartExperimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startExperiment(request))
  def deleteExperiment(request: DeleteExperimentRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.DeleteExperimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteExperiment(request))
  def getFeature(request: GetFeatureRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.GetFeatureResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFeature(request))
  def updateProjectDataDelivery(request: UpdateProjectDataDeliveryRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.UpdateProjectDataDeliveryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProjectDataDelivery(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createProject(request: CreateProjectRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def startLaunch(request: StartLaunchRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.StartLaunchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startLaunch(request))
  def listFeatures(request: ListFeaturesRequest): ZStream[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.FeatureSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listFeatures(request))
  def listFeaturesPaginated(
      request: ListFeaturesRequest
  ): ZIO[zio.aws.evidently.Evidently, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listFeaturesPaginated(request))
  def evaluateFeature(request: EvaluateFeatureRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.EvaluateFeatureResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.evaluateFeature(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def updateExperiment(request: UpdateExperimentRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.UpdateExperimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateExperiment(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listExperiments(request: ListExperimentsRequest): ZStream[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.Experiment.ReadOnly
  ] = ZStream.serviceWithStream(_.listExperiments(request))
  def listExperimentsPaginated(request: ListExperimentsRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.ListExperimentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExperimentsPaginated(request))
  def stopExperiment(request: StopExperimentRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.StopExperimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopExperiment(request))
  def deleteProject(request: DeleteProjectRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
  def updateFeature(request: UpdateFeatureRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.UpdateFeatureResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFeature(request))
  def getExperiment(request: GetExperimentRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.GetExperimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getExperiment(request))
  def listLaunches(request: ListLaunchesRequest): ZStream[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.Launch.ReadOnly
  ] = ZStream.serviceWithStream(_.listLaunches(request))
  def listLaunchesPaginated(request: ListLaunchesRequest): ZIO[
    zio.aws.evidently.Evidently,
    AwsError,
    zio.aws.evidently.model.ListLaunchesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLaunchesPaginated(request))
}
