package zio.aws.evidently.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.{Timestamp, SplitWeight, GroupName}
import scala.jdk.CollectionConverters._
final case class ScheduledSplitConfig(
    groupWeights: Map[GroupName, SplitWeight],
    segmentOverrides: Optional[
      Iterable[zio.aws.evidently.model.SegmentOverride]
    ] = Optional.Absent,
    startTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ScheduledSplitConfig = {
    import ScheduledSplitConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ScheduledSplitConfig
      .builder()
      .groupWeights(
        groupWeights
          .map({ case (key, value) =>
            (GroupName.unwrap(key): java.lang.String) -> (SplitWeight.unwrap(
              value
            ): java.lang.Long)
          })
          .asJava
      )
      .optionallyWith(
        segmentOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segmentOverrides)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ScheduledSplitConfig.ReadOnly =
    zio.aws.evidently.model.ScheduledSplitConfig.wrap(buildAwsValue())
}
object ScheduledSplitConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ScheduledSplitConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ScheduledSplitConfig =
      zio.aws.evidently.model.ScheduledSplitConfig(
        groupWeights,
        segmentOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTime
      )
    def groupWeights: Map[GroupName, SplitWeight]
    def segmentOverrides
        : Optional[List[zio.aws.evidently.model.SegmentOverride.ReadOnly]]
    def startTime: Timestamp
    def getGroupWeights: ZIO[Any, Nothing, Map[GroupName, SplitWeight]] =
      ZIO.succeed(groupWeights)
    def getSegmentOverrides: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.SegmentOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("segmentOverrides", segmentOverrides)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplitConfig
  ) extends zio.aws.evidently.model.ScheduledSplitConfig.ReadOnly {
    override val groupWeights: Map[GroupName, SplitWeight] = impl
      .groupWeights()
      .asScala
      .map({ case (key, value) =>
        zio.aws.evidently.model.primitives.GroupName(
          key
        ) -> zio.aws.evidently.model.primitives.SplitWeight(value)
      })
      .toMap
    override val segmentOverrides
        : Optional[List[zio.aws.evidently.model.SegmentOverride.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentOverrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.SegmentOverride.wrap(item)
          }.toList
        )
    override val startTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplitConfig
  ): zio.aws.evidently.model.ScheduledSplitConfig.ReadOnly = new Wrapper(impl)
}
