package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  MetricUnitLabel,
  CwDimensionSafeName,
  MetricDefinitionConfigEventPatternString,
  JsonPath
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetricDefinitionConfig(
    entityIdKey: JsonPath,
    eventPattern: Optional[MetricDefinitionConfigEventPatternString] =
      Optional.Absent,
    name: CwDimensionSafeName,
    unitLabel: Optional[MetricUnitLabel] = Optional.Absent,
    valueKey: JsonPath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.MetricDefinitionConfig = {
    import MetricDefinitionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.MetricDefinitionConfig
      .builder()
      .entityIdKey(JsonPath.unwrap(entityIdKey): java.lang.String)
      .optionallyWith(
        eventPattern.map(value =>
          MetricDefinitionConfigEventPatternString.unwrap(
            value
          ): java.lang.String
        )
      )(_.eventPattern)
      .name(CwDimensionSafeName.unwrap(name): java.lang.String)
      .optionallyWith(
        unitLabel.map(value => MetricUnitLabel.unwrap(value): java.lang.String)
      )(_.unitLabel)
      .valueKey(JsonPath.unwrap(valueKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly =
    zio.aws.evidently.model.MetricDefinitionConfig.wrap(buildAwsValue())
}
object MetricDefinitionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.MetricDefinitionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.MetricDefinitionConfig =
      zio.aws.evidently.model.MetricDefinitionConfig(
        entityIdKey,
        eventPattern.map(value => value),
        name,
        unitLabel.map(value => value),
        valueKey
      )
    def entityIdKey: JsonPath
    def eventPattern: Optional[MetricDefinitionConfigEventPatternString]
    def name: CwDimensionSafeName
    def unitLabel: Optional[MetricUnitLabel]
    def valueKey: JsonPath
    def getEntityIdKey: ZIO[Any, Nothing, JsonPath] = ZIO.succeed(entityIdKey)
    def getEventPattern
        : ZIO[Any, AwsError, MetricDefinitionConfigEventPatternString] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getName: ZIO[Any, Nothing, CwDimensionSafeName] = ZIO.succeed(name)
    def getUnitLabel: ZIO[Any, AwsError, MetricUnitLabel] =
      AwsError.unwrapOptionField("unitLabel", unitLabel)
    def getValueKey: ZIO[Any, Nothing, JsonPath] = ZIO.succeed(valueKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.MetricDefinitionConfig
  ) extends zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly {
    override val entityIdKey: JsonPath =
      zio.aws.evidently.model.primitives.JsonPath(impl.entityIdKey())
    override val eventPattern
        : Optional[MetricDefinitionConfigEventPatternString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventPattern())
        .map(value =>
          zio.aws.evidently.model.primitives
            .MetricDefinitionConfigEventPatternString(value)
        )
    override val name: CwDimensionSafeName =
      zio.aws.evidently.model.primitives.CwDimensionSafeName(impl.name())
    override val unitLabel: Optional[MetricUnitLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.unitLabel())
      .map(value => zio.aws.evidently.model.primitives.MetricUnitLabel(value))
    override val valueKey: JsonPath =
      zio.aws.evidently.model.primitives.JsonPath(impl.valueKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.MetricDefinitionConfig
  ): zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly = new Wrapper(impl)
}
