package zio.aws.evidently.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.{SegmentRef, NextToken, MaxReferences}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSegmentReferencesRequest(
    maxResults: Optional[MaxReferences] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    segment: SegmentRef,
    `type`: zio.aws.evidently.model.SegmentReferenceResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListSegmentReferencesRequest = {
    import ListSegmentReferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListSegmentReferencesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxReferences.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .segment(SegmentRef.unwrap(segment): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.evidently.model.ListSegmentReferencesRequest.ReadOnly =
    zio.aws.evidently.model.ListSegmentReferencesRequest.wrap(buildAwsValue())
}
object ListSegmentReferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListSegmentReferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListSegmentReferencesRequest =
      zio.aws.evidently.model.ListSegmentReferencesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        segment,
        `type`
      )
    def maxResults: Optional[MaxReferences]
    def nextToken: Optional[NextToken]
    def segment: SegmentRef
    def `type`: zio.aws.evidently.model.SegmentReferenceResourceType
    def getMaxResults: ZIO[Any, AwsError, MaxReferences] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSegment: ZIO[Any, Nothing, SegmentRef] = ZIO.succeed(segment)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.evidently.model.SegmentReferenceResourceType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListSegmentReferencesRequest
  ) extends zio.aws.evidently.model.ListSegmentReferencesRequest.ReadOnly {
    override val maxResults: Optional[MaxReferences] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.evidently.model.primitives.MaxReferences(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
    override val segment: SegmentRef =
      zio.aws.evidently.model.primitives.SegmentRef(impl.segment())
    override val `type`: zio.aws.evidently.model.SegmentReferenceResourceType =
      zio.aws.evidently.model.SegmentReferenceResourceType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListSegmentReferencesRequest
  ): zio.aws.evidently.model.ListSegmentReferencesRequest.ReadOnly =
    new Wrapper(impl)
}
